package com.kdgcsoft.jt.xzzf.dubbo.xzsp.bulkTransportationApi.service;

import com.kdgcsoft.jt.xzzf.common.exception.BusinessException;
import com.kdgcsoft.jt.xzzf.dubbo.xzsp.bulkTransportationApi.entity.AreaRoadsVO;
import com.kdgcsoft.jt.xzzf.dubbo.xzsp.bulkTransportationApi.entity.BusinessCodeVO;
import com.kdgcsoft.jt.xzzf.dubbo.xzsp.bulkTransportationApi.entity.CommentVO;
import com.kdgcsoft.jt.xzzf.common.rest.Result;
import com.kdgcsoft.jt.xzzf.dubbo.xzsp.xkbl.entity.SncxscxxVo;

import java.util.List;
/**
 * <p>
 * 大件运输 - 调用部里面的接口
 * </p>
 *
 * @author 费黎明
 * @since 2020-03-31
 */

public interface BulkTransportationApi {

    /**
     * 用于起运地省份提交受理操作结果
     */
    public Result accept (String reqNo, String distCode, BusinessCodeVO businessCode, String comments) throws BusinessException;
    /**
     * 用于跨省系统省级平台提交审查操作结果
     */
    public Result examine (String reqNo, String distCode, BusinessCodeVO businessCode, CommentVO comments, String effect) throws BusinessException;
    /**
     * 用于起运地省份提交协调操作结果
     */
    public Result coordinate (String reqNo, String distCode, String planList, BusinessCodeVO businessCode, String comments, List<AreaRoadsVO> areaRoads) throws BusinessException;
    /**
     * 用于起运地省份提交许可决定操作结果
     */
    public Result decision (String reqNo,String distCode,BusinessCodeVO businessCode,String comments) throws BusinessException;
    /**
     * 用于起运地省份提交发证操作结果
     */
    public Result subIssue (String reqNo,String distCode,BusinessCodeVO businessCode,String comments) throws BusinessException;
    /**
     * 用于起运地省份提交勘验不通过操作结果
     */
    public Result checkFail (String reqNo) throws BusinessException;

    /**
     * 省内超限实施审批记录信息上传接口
     *
     * @return LargeTransResultVO
     */
    Result subNewProcess(SncxscxxVo sncxscxxVo) throws Exception;
}
