package com.kdgcsoft.jt.xzzf.dubbo.xzsp.basicDataManage.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.dubbo.xzsp.basicDataManage.entity.YjgzVo;

/**
 * <p>
 *  服务类
 * </p>
 *
 * @author ln
 * @since 2020-03-24
 */
public interface YjgzService {

    /**
     * 预警规则分页查询 用于风险预警页面
     * @param current 当前页
     * @param size 每页显示条数
     * @param yjgzVo 查询条件
     * @return page 实施事项分页信息
     */
    Page<YjgzVo> page(long current, long size, YjgzVo yjgzVo);

    /**
     * 新增风险预警规则信息
     *
     * @param yjgzVo 新增的风险预警信息
     * @return true 新增成功  false 新增失败
     */
    boolean insert(YjgzVo yjgzVo);

    /**
     * 修改风险预警规则信息
     *
     * @param yjgzVo 修改的风险预警信息
     * @return true 修改成功  false 修改失败
     */
    boolean updateById(YjgzVo yjgzVo);

    /**
     * 删除预警规则信息 风险预警页面删除、批量删除
     * delete_flag '00' 未删除  '01'  已删除
     * @param yjgzVo 删除的数据参数
     * @return true 成功  false 失败
     */
    boolean deleteById(YjgzVo yjgzVo);

    /**
     * 根据id获取预警规则信息  用于风险预警管理 查看弹框、编辑弹框
     * @param id 预警规则id
     * @return yjgzInfo true 返回预警规则信息
     */
    YjgzVo getById(String id);

    /**
     * 启用、停用 用于风险预警页面启用/停用
     * 1 启用  0 停用
     * @param yjgzVo 预警规则id
     * @return 返回值 >0 修改成功 ==修改数 全部修改成功 ==0 修改失败
     */
    int enableOrDisable(YjgzVo yjgzVo);

}

