package com.kdgcsoft.jt.xzzf.dubbo.xzsp.basicDataManage.service;

import com.kdgcsoft.jt.xzzf.dubbo.xzsp.basicDataManage.entity.SxclmlVo;

import java.util.List;

/**
 * <p>
 *  服务类
 * </p>
 *
 * @author ln
 * @since 2020-05-29
 */
public interface SxclmlService {

    /**
     * 根据实施事项id查询对应实施事项的事项材料目录
     * @param sssxid 实施事项id
     * @return List<SxclmlVo> 事项材料目录列表信息
     */
    List<SxclmlVo> findSxclmlList(String sssxid);

    /**
     * 根据事项材料目录id查询对应的事项材料目录详情
     * @param sxclmlid
     * @return SxclmlVo
     */
    SxclmlVo findSxclmlById(String sxclmlid);

    /**
     * 保存事项材料目录信息
     * @param sxclmlVo 事项材料目录信息
     * @return boolean
     */
    boolean saveSxclml(SxclmlVo sxclmlVo);

    /**
     * 根据id删除事项材料目录
     * 将delete_flag 更改为 01 逻辑删除
     * @param sxclmlVo 事项材料目录
     * @return boolean
     */
    boolean delSxclmlById(SxclmlVo sxclmlVo);

}

