package com.kdgcsoft.jt.xzzf.dubbo.xzsp.basicDataManage.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;
import com.kdgcsoft.jt.xzzf.dubbo.xzsp.basicDataManage.entity.*;

import java.util.List;

/**
 * <p>
 *  服务类
 * </p>
 *
 * @author ln
 * @since 2020-03-25
 */
public interface SssxService {

    /**
     * 分页查询
     *
     * @param current 当前页
     * @param size 每页显示条数
     * @param sssxVo
     * @return
     */
    Page<SssxVo> page(long current, long size, SssxVo sssxVo);

    /**
     * 查询匹配信息  用于实施事项管理页面  编辑弹框  匹配信息
     * @param sssxid  实施事项id
     * @return SxxxVo 事项信息
     */
    SxxxVo findPpxxInfo(String sssxid);

    /**
     * 根据实施事项id查询对应实施事项审批环节
     * @param sssxVo 实施事项
     * @return List<SphjVo> 审批环节列表信息
     */
    List<SphjVo> findSphjList(SssxVo sssxVo);

    /**
     * 根据实施事项id查询实施事项信息
     * @param sssxid 实施事项id
     * @return SssxVo 实施事项信息
     */
    SssxVo findSssxInfo(String sssxid);

    /**
     * 根据 实施事项id 和 环节编码 查询审批环节信息
     * @param sssxid 实施事项id
     * @param actCode 环节编码
     * @return SphjVo 审批环节信息
     */
    SphjVo findSphjBySssxidAC(String sssxid, String actCode);

    /**
     * 根据sxxxid修改事项信息 用于实施事项管理页面  编辑弹窗
     * @param sssxVo 修改数据
     * @return true 修改成功  false 修改失败
     */
    boolean saveSssx(SssxVo sssxVo, SysUser sysUser);

    /**
     * 保存审批环节
     * @param sphjVos 审批环节信息
     * @param sysUser  当前用户信息
     * @return boolean
     */
    boolean saveSphj(List<SphjVo> sphjVos, SysUser sysUser);

    /**
     * 实施事项版本个数
     * @param sssxbm 实施事项编码
     * @param sssxbbh 实施事项版本号
     * @return int 版本数量
     */
    Integer versionCount(String sssxbm, long sssxbbh);

    /**
     * 通过id和版本号查询实施事项信息
     *
     * @param sssxbm  实施事项编码
     * @param sssxbbh 实施事项版本号
     * @return sssxVo 实施事项信息
     */
    SssxVo searchSssxByIdAndBbh(String sssxbm, long sssxbbh);

    /**
     * 上个版本号
     * @param sssxbm 实施事项编码
     * @param sssxbbh 实施事项版本号
     * @return oldSssx 最新的版本号
     */
    long findOldSssxBbhById(String sssxbm, long sssxbbh);

    /**
     * 通过id和版本号查询实施事项项目
     * @param sssxVo 实施事项id
     * @return sssxInfoList 实施事项列表信息
     */
    List<SssxVo> searchSssxForExcel(List<String> sssxVo);

    /**
     * 通过id和版本号查询实施事项项目
     * @param sssxVo 实施事项id
     * @return sssxInfoList 实施事项列表信息
     */
    List<SssxVo> searchSssxByQuery(SssxVo sssxVo);

    /**
     * 根据事项清单编码查询关联的实施事项信息
     * @param sxbms 事项编码数组
     * @return  实施事项列表信息
     */
    List<SssxVo> searchSssxBySxbms(List<String> sxbms);

//    Page<SpryVo> searchSpryPage(Long current, Long size, SpryVo spryVo);

    /**
     * 根据审批环节id查询审批人员信息
     * @param spryVo 查询条件
     * @return
     */
    Page<SpryVo> searchSpryBySphj(Long page, Long rows, SpryVo spryVo);

    /**
     * 根据审批环节信息查询审批人员信息
     * @param sssxid 实施事项id
     * @param hjbm 环节编码
     * @return
     */
    List<SpryVo> searchSpryBySphj(String sssxid, String hjbm);

    /**
     * 根据审批环节id查询对应的审批人员
     * @param sphjid 审批环节id
     * @return SpryVo
     */
    SpryVo findAllSpryBySphj(String sphjid);

    /**
     * 将人员绑定到该审批环节
     * @param spryVo
     * @return
     */
    boolean bindSpryBySphj(SpryVo spryVo);

    /**
     * 人员解除绑定该审批环节
     * @param spryVo 审批人员信息
     * @return
     */
    boolean unBindSpryBySphy(SpryVo spryVo);

    /**
     * 根据实施事项编码批量处理绑定审批人员
     * @param sssxVo 实施事项信息（已配置完成的事项 sssxbm 未配置/需要更改的实施事项 sssxbms）
     * @return boolean
     */
    boolean mulitDealBindSpryBySssx(SssxVo sssxVo, SysUser sysUser);

    /**
     * 将A赋给B;在复制之前将A中不存在的审批人员在B中删除
     * @param sssxVo 实施事项信息（已配置完成的事项 sssxbm 未配置/需要更改的实施事项 sssxbms）
     * @return boolean
     */
    boolean clearSpry(SssxVo sssxVo);

    /**
     * 查询实施事项配置信息
     * @param sssxid 实施事项id
     * @return sssxConfigureResultVO 实施事项配置信息
     */
//    SssxConfigureResultVO findSssxPzInfo(String sssxid);
}

