package com.kdgcsoft.jt.xzzf.dubbo.xzsp.basicDataManage.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.common.rest.Result;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;
import com.kdgcsoft.jt.xzzf.dubbo.xzsp.basicDataManage.entity.JYwbmVo;
import com.kdgcsoft.jt.xzzf.dubbo.xzsp.basicDataManage.entity.JYwbmmxVo;

/**
 * <p>
 * 行政审批-业务编码管理 服务类
 * </p>
 *
 * @author 刘梦寻
 * @since 2020-03-25
 */
public interface BusinessCodeService {

    /**
     * 新增行政审批-业务编码信息
     *
     * @param jYwbmVo  业务编码
     * @return
     */
    boolean insert(JYwbmVo jYwbmVo,SysUser curUser) throws Exception;

    /**
     * 修改行政审批-业务编码信息
     *
     * @param jYwbmVo  业务编码
     * @return
     */
    boolean updateById(JYwbmVo jYwbmVo) throws Exception;

    /**
     * 修改行政审批-业务编码详细信息
     *
     * @param jYwbmmxVo  业务编码明细
     * @return
     */
    boolean updateByDetailId(JYwbmmxVo jYwbmmxVo);

    /**
     * 更新行政审批-业务编码详细表-号起始值
     *
     * @param jYwbmmxVo 业务编码明细
     * @return
     */
    Result updateHQSZ(JYwbmmxVo jYwbmmxVo);

    /**
     * 更新行政审批-业务编码详细表-号当前值
     *
     * @param jYwbmmxVo 业务编码明细
     * @return
     */
    Result updateHDQZ(JYwbmmxVo jYwbmmxVo);

    /**
     * 根据ID删除行政审批-业务编码详细信息
     *
     * @param id　业务编码明细ID
     * @return
     */
    boolean deleteByDetailId(String id);

    /**
     * 根据ID获取行政审批-业务编码信息
     *
     * @param id 业务编码ID
     * @return
     */
    JYwbmVo getById(String id,SysUser curUser);

    /**
     * 分页查询
     *
     * @param current 当前页
     * @param size 每页显示条数
     * @param jYwbmVo 业务编码
     * @return
     */
    Page<JYwbmVo> page(long current, long size, JYwbmVo jYwbmVo);

}

