package com.kdgcsoft.jt.xzzf.dubbo.xzsp.basicDataManage.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.common.component.ComboboxVo;
import com.kdgcsoft.jt.xzzf.dubbo.xzsp.basicDataManage.entity.SxxxVo;

import java.util.HashMap;
import java.util.List;

/**
 * <p>
 * 行政审批-事项清单管理 服务类
 * </p>
 *
 * @author 刘梦寻
 * @since 2020-03-31
 */
public interface AuthorityItemService {

    /**
     * 分页查询
     *
     * @param page 分页信息
     * @param sxxxVo 业务编码
     * @return
     */
    IPage<SxxxVo> page(IPage page, SxxxVo sxxxVo);

    /**
     * 新增行政审批-事项清单信息
     *
     * @param sxxxVo  事项清单信息
     * @return
     */
    boolean insert(SxxxVo sxxxVo) throws Exception;

    /**
     * 修改行政审批-事项清单信息
     *
     * @param sxxxVo  事项清单
     * @return
     */
    boolean updateById(SxxxVo sxxxVo) throws Exception;

    /**
     * 批量更新行政审批-事项清单信息
     *
     * @param sxxxVo  事项清单
     * @param sxxxIds 事项信息id数组
     * @return
     */
    boolean updateByIds(SxxxVo sxxxVo,String[] sxxxIds);

    /**
     * 批量更新行政审批-事项清单信息
     *
     * @param sxxxVo  事项清单
     * @param sxbms 事项编码数组
     * @return
     */
    boolean updateBySxbms(SxxxVo sxxxVo,String[] sxbms);

    /**
     * 根据ID获取行政审批-事项清单信息
     *
     * @param id 事项清单ID
     * @return
     */
    SxxxVo getById(String id);

    /**
     * 根据事项编码获取行政审批-事项清单信息
     *
     * @param sxbm 事项编码
     * @return
     */
    List<SxxxVo> getBySxbm(String sxbm);

    /**
     * 根据ID列表获取行政审批-事项清单信息
     *
     * @param sxxxIds 事项清单ID列表
     * @return
     */
    List<SxxxVo> getByIds(List<String> sxxxIds);

    /**
     * 根据查询参数获取行政审批-事项清单信息
     *
     * @param sxxxVo 查询参数
     * @return
     */
    List<SxxxVo> getByQuery(SxxxVo sxxxVo);

    /**
     * 根据事项名称检索事项
     *
     * @param sxmc 事项名称
     * @return
     */
    List<String> searchByName(String sxmc);

    /**
     * 比较同一事项编码对应事项信息
     * @param oldSxxxVo 旧版本事项
     * @param sxxxVo 当前版本事项
     * @return
     */
    HashMap<String, SxxxVo> compareSxxxInfo(SxxxVo oldSxxxVo, SxxxVo sxxxVo);

}

