package com.kdgcsoft.jt.xzzf.dubbo.xzsp.basicDataManage.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * <p>
 * 公路路线基本情况明细表 实体类VO
 * </p>
 *
 * @author 刘梦寻
 * @since 2020-08-31
 */
@Data
@TableName("XZSP_J_GLLXMX")
public class XzspJGllxmxVO implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    private String gllxmxid;

    /**
     * 路线编号
     */
    private String lxbh;

    /**
     * 所在行政区划代码
     */
    private String xzqhdm;

    /**
     * 路线名称
     */
    private String lxmc;

    /**
     * 起点名称
     */
    private String qdmc;

    /**
     * 止点名称
     */
    private String zdmc;

    /**
     * 起点桩号
     */
    private BigDecimal qdzh;

    /**
     * 起点桩号起（查询参数）
     */
    @TableField(exist = false)
    private BigDecimal qdzhq;

    /**
     * 起点桩号止（查询参数）
     */
    @TableField(exist = false)
    private BigDecimal qdzhz;

    /**
     * 止点桩号
     */
    private BigDecimal zdzh;

    /**
     * 止点桩号起（查询参数）
     */
    @TableField(exist = false)
    private BigDecimal zdzhq;

    /**
     * 止点桩号止（查询参数）
     */
    @TableField(exist = false)
    private BigDecimal zdzhz;

    /**
     * 里程（公里）
     */
    private BigDecimal lc;

    /**
     * 里程起（单位公里，查询参数）
     */
    @TableField(exist = false)
    private BigDecimal lcq;

    /**
     * 里程止（单位公里，查询参数）
     */
    @TableField(exist = false)
    private BigDecimal lcz;

    /**
     * 技术等级代码
     */
    private String jsdjdm;

    /**
     * 技术等级名称
     */
    private String jsdjmc;

    /**
     * 是否一幅高速
     */
    private String sfyfgs;

    /**
     * 车道数量
     */
    private Integer cdsl;

    /**
     * 面层类型代码
     */
    private String mclxdm;

    /**
     * 面层类型类型
     */
    private String mclxmc;

    /**
     * 路基宽度(米)
     */
    private BigDecimal ljkd;

    /**
     * 路面宽度(米)
     */
    private BigDecimal lmkd;

    /**
     * 面层厚度(厘米)
     */
    private BigDecimal mchd;

    /**
     * 设计时速
     */
    private Integer sjss;

    /**
     * 修建年度
     */
    private Integer xjnd;

    /**
     * 改建年度
     */
    private Integer gjnd;

    /**
     * 最近一次修复养护年度
     */
    private Integer zjxfnd;

    /**
     * 断链类型
     */
    private String dllx;

    /**
     * 是否城管路段
     */
    private String sfcgld;

    /**
     * 是否断头路段
     */
    private String sfdtld;

    /**
     * 收费路段性质
     */
    private String sflxxz;

    /**
     * 重复路段编号
     */
    private String cfldbh;

    /**
     * 重复路段起点桩号
     */
    private BigDecimal cfldqdzh;

    /**
     * 重复路段终点桩号
     */
    private BigDecimal cfldzdzh;

    /**
     * 养护里程（公里）
     */
    private BigDecimal yhlc;

    /**
     * 可绿化里程（公里）
     */
    private BigDecimal klhlc;

    /**
     * 已绿化里程（公里）
     */
    private BigDecimal ylhlc;

    /**
     * 地貌代码
     */
    private String dmdm;

    /**
     * 地貌名称
     */
    private String dmmc;

    /**
     * 涵洞数量（个）
     */
    private Integer hdsl;

    /**
     * 管养单位名称
     */
    private String gydwmc;

    /**
     * 省际出入口
     */
    private String sjcrk;

    /**
     * 国道调整前路线编号
     */
    private String gdtzqlxbh;

    /**
     * 是否按干线公路管理接养
     */
    private String sfagxglgljy;

    /**
     * 备注
     */
    private String remark;

    public String getId() {
        return gllxmxid;
    }

    public void setId(String id) {
        this.gllxmxid = id;
    }

}
