package com.kdgcsoft.jt.xzzf.dubbo.xzsp.basicDataManage.entity;

import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;

/**
 * <p>
 * 行政审批-业务编码
 * </p>
 *
 * @author 刘梦寻
 * @since 2020-03-25
 */
@Data
@TableName("XZSP_J_YWBM")
public class JYwbmVo extends BaseEntity<String> {

    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    @TableId("YWBMID")
    private String ywbmid;

    /**
     * 业务编码
     */
    private String ywbm;

    /**
     * 业务编码名称
     */
    private String ywbmmc;

    /**
     * 字
     */
    private String z;

    /**
     * 号前缀-本单位使用或全部单位使用时存储
     */
    private String hqz;

    /**
     * 号后缀-本单位使用或全部单位使用时存储
     */
    private String hhz;

    /**
     * 号起始值-本单位使用或全部单位使用时存储
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private Long hqsz;

    /**
     * 是否按年重置-1是0否
     */
    private String sfancz;

    /**
     * 关联的业务编码明细信息
     */
    @TableField(exist = false)
    private String detailVos;

    /**
     * 业务编码明细表id
     */
    @TableField(exist = false)
    private String ywbmmxid;

    /**
     * 单位名称
     */
    @TableField(exist = false)
    private String jg;

    /**
     * 年份
     */
    @TableField(exist = false)
    private Long nf;

    /**
     * 当前顺序号
     */
    @TableField(exist = false)
    private Long dqsxh;

    /**
     * 组织机构
     */
    @TableField(exist = false)
    private String zzjg;

    /**
     * 查询范围（01：本单位 02：下属机构）
     */
    @TableField(exist = false)
    private String cxfw;

    /**
     * 使用范围（1：本单位 2：多个单位）
     */
    @TableField(exist = false)
    private String syfw;

    @Override
    public String getId() {
        return ywbmid;
    }

    @Override
    public void setId(String id) {
        this.ywbmid = id;
    }
}
