package com.kdgcsoft.jt.xzzf.dubbo.xtba.zfyq.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.dubbo.xtba.zfyq.entity.CfsjVO;
import com.kdgcsoft.jt.xzzf.dubbo.xtba.zfyq.entity.PdfVersionVo;
import com.kdgcsoft.jt.xzzf.dubbo.xtba.zfyq.entity.XkWorkFlowListInforVO;

import java.util.List;

/**
 * @Author xwj
 * @CLASS_NAME: ZfyqXzcfService
 * @Description 执法一期 行政处罚 案件信息服务层接口
 * @Date 2021/2/26 11:13
 * @Version 1.0
 */
public interface XzcfcxService {

    /*****
     * 分页查询
     * @param page 分页信息
     * @param entity 实体类
     * @param curUserOrgId 当前登录用户组织机构Id
     * @return
     */
    Page<CfsjVO> page(Page<CfsjVO> page, CfsjVO entity, String curUserOrgId);

    /**
     * 根据处罚事件id获取处罚事件信息
     * @param cfsjVO
     * @return
     */
    CfsjVO selectById(CfsjVO cfsjVO);

    /**
     * 获取pdf文书路径的列表
     * @param pdfVersionVo
     * @return
     */
    List<PdfVersionVo> getWenShuUrlPdf(PdfVersionVo pdfVersionVo);

    /**
     * 获取归档文书的路径
     * @param pdfVersionVo
     * @return
     */
    List<PdfVersionVo> selectPdfGuiDangUrl(PdfVersionVo pdfVersionVo);

    /**
     * 查看操作历史
     * @param xkWorkFlowListInforVO
     * @return
     */
    List<XkWorkFlowListInforVO> getWorkFlowList(XkWorkFlowListInforVO xkWorkFlowListInforVO);
}
