package com.kdgcsoft.jt.xzzf.dubbo.xtba.zfyq.entity;

import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * 执法一期 操作历史
 */

@Data
@TableName(DataSourceConstant.DATA_SOURCE_XZCF + "WF_J_HISTORYOPERATION")
public class XkWorkFlowListInforVO  extends BaseEntity<String> {

	private static final long serialVersionUID = 1L;
	/**
	 * 主键id
	 */
	@TableId("ID")
	private String id;

	/**
	 * 工作流Id ENTRY_ID
	 */
	private String entryId;

	/**
	 * 办理环节名称 STEP_NAME
	 */
	private String stepName;

	/**
	 * 执行动作 ACTION_NAME
	 */
	private String actionName;

	/**
	 * 操作人id CALLER
	 */
	private String caller;

	/**
	 * 执行意见 OPINION
	 */
	private String opinion;

	/**
	 * 操作时间 OPINION_TIME
	 */
	@DateTimeFormat(pattern = "yyyy-MM-dd")
	@JSONField(format = "yyyy-MM-dd")
	private Date opinionTime;

	/**
	 * 经办人id
	 */
	@TableField(exist = false)
	private String jingBanRen;

	/**
	 * 经办人姓名
	 */
	@TableField(exist = false)
	private String jingBanRenName;

	/**
	 * 经办单位
	 */
	@TableField(exist = false)
	private String jingBanDanWei;
	
}
