package com.kdgcsoft.jt.xzzf.dubbo.xtba.zfyq.entity;

import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * @Author xwj
 * @CLASS_NAME: CfsjVO
 * @Description 处罚案件信息实体类 （对应着执法一期违法案件的数据）
 * @Date 2021/2/25 14:25
 * @Version 1.0
 */
@Data
@TableName(DataSourceConstant.DATA_SOURCE_XZCF + "XZCF_D_CFSJCX")
public class CfsjVO extends BaseEntity<String> {

    private static final long serialVersionUID = 1L;

    /**
     * 处罚案件信息主键 CHU_FA_SHI_JIAN_ID
     */
    @TableId("CHU_FA_SHI_JIAN_ID")
    private String chuFaShiJianId;

    /**
     * 案件类别  AN_JIAN_LEI_BIE
     * 01：一般，02：简易
     */
    private String anJianLeiBie;

    /**
     * 受案时间  SHOU_AN_SHI_JIAN
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JSONField(format = "yyyy-MM-dd")
    private Date shouAnShiJian;

    /**
     * 处理状态  CHU_LI_ZHUANG_TAI 办结状态  01-开始活动  02--在办  03--待归档结束活动  04已归档结束活动
     */
    private String chuLiZhuangTai;

    /**
     * 案件来源  AN_JIAN_LAI_YUAN 01 表示现场执法 ！=09 前台传02表示非现场执法 =09
     */
    private String anJianLaiYuan;

    /**
     * 案号  AN_HAO
     */
    private String anHao;

    /**
     * 案由  AN_YOU
     */
    private String anYou;

    /**
     * 当事人  DANG_SHI_REN
     */
    private String dangShiRen;

    /**
     * 执法机关  ZHI_FA_JI_GUAN == 调查机构
     */
    private String zhiFaJiGuan;

    /**
     * 立案时间  LI_AN_SHI_JIAN
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JSONField(format = "yyyy-MM-dd")
    private Date liAnShiJian;

    /**
     * 结案时间  JIE_AN_SHI_JIAN
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JSONField(format = "yyyy-MM-dd")
    private Date jieAnShiJian;

    /**
     * 处罚机构ID  CHU_FA_ORG_ID
     */
    private String chuFaOrgId;

    /**
     *   ORG_ID
     */
    private String orgId;

    /**
     * 工作流ID   GONG_ZUO_LIU_ID
     */
    private String gongZuoLiuId;

    /**
     * 编号 BIAN_HAO
     */
    private String bianHao;

    /**
     * 处罚金额  CHU_FA_JIN_E
     */
    private String chuFaJinE;

    /**
     * 创建者
     */
    private String creater;

    /**
     * 创建时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JSONField(format = "yyyy-MM-dd")
    private Date createtime;

    /**
     * 更新人
     */
    private String updater;

    /**
     * 更新时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JSONField(format = "yyyy-MM-dd")
    private Date updatetime;

    /**
     * 删除标志 DELETEFLAG
     */
    private String deleteflag;

    /**
     * 一般行政处罚--处罚决定日期  XZCFJDS_JUE_DING_RI_QI
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JSONField(format = "yyyy-MM-dd")
    private Date xzcfjdsJueDingRiQi;

    /**
     * 当场行政处罚--处罚决定日期  DCXZCFJDS_JUE_DING_RI_QI
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JSONField(format = "yyyy-MM-dd")
    private Date dcxzcfjdsJueDingRiQi;

    /**
     * 海事当场行政处罚--处罚决定日期  HSDCXZCFJDS_JUE_DING_RI_QI
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JSONField(format = "yyyy-MM-dd")
    private Date hsdcxzcfjdsJueDingRiQi;

    /**
     * 海事行政处罚--处罚决定日期  HSXZCFJDS_JUE_DING_RI_QI
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JSONField(format = "yyyy-MM-dd")
    private Date hsxzcfjdsJueDingRiQi;

    /**
     * 步骤名称 STEP_NAME
     */
    private String stepName;

    /**
     * 车牌号  CHE_PAI_HAO
     */
    private String chePaiHao;

    /**
     * 船舶牌号  CHUAN_BO_PAI_HAO
     */
    private String chuanBoPaiHao;

    /**
     * 组织机构名称  ORG_NAME
     */
    private String orgName;

    /**
     * 当前步骤ID  STEP_ID
     */
    private String stepId;

    /**
     * 强制文书标志  QZ_WEN_SHU_BIAO_JI
     */
    private String qzWenShuBiaoJi;

    /**
     * 过车牌号  GUA_CHE_HAO_PAI
     */
    private String guaCheHaoPai;

    /**
     * 更新ORG的标志 00已修改id,01已修改名称 ，null 未修改
     */
    private String updateOrgFlag;

    /**
     * 车船号
     */
    @TableField(exist = false)
    private String cheChuanHao;


    /**
     * 查询范围
     * 00 本单位
     * 01 下属单位
     * 02 本单位及下属单位
     * null 全部
     */
    @TableField(exist = false)
    private String chaXunFanWei;

    /**
     * 处罚金额前台 开始
     */
    @TableField(exist = false)
    private String startChuFaJinE;

    /**
     * 处罚金额前台 结束
     */
    @TableField(exist = false)
    private String  endChuFaJinE;

    /**
     * 音视频调阅前台页面传的参数，如果01表示关联，02表示不关联 不传查全部
     */
    @TableField(exist = false)
    private String yinShiPingDiaoYue;

    /**
     * 机构类别
     * 前台传的数据
     * 不传 null--表示全部
     * 01--调查机构
     * 02--处理机构
     */
    @TableField(exist = false)
    private String jiGouLeiBie;

    /**
     * 受案时间 开始
     */
    @TableField(exist = false)
    private String startShouAn;

    /**
     * 受案时间 结束
     */
    @TableField(exist = false)
    private String endShouAn;

    /**
     * 结案时间 开始
     */
    @TableField(exist = false)
    private String startJieAn;

    /**
     * 结案时间 结束
     */
    @TableField(exist = false)
    private String endJieAn;

    /**
     * 一期组织机构ids
     */
    @TableField(exist = false)
    private String [] yiqiOrgIds;

    /**
     * 二期组织机构IDS
     */
    @TableField(exist = false)
    private String erqiOrgIds;

    /**
     * 二期组织机构IDS
     */
    @TableField(exist = false)
    private String erqiOrgMcs;

    @Override
    public String getId() {
        return this.chuFaShiJianId;
    }

    @Override
    public void setId(String id) {
        this.chuFaShiJianId = id;
    }
}
