package com.kdgcsoft.jt.xzzf.dubbo.xtba.xtgl.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;
import com.kdgcsoft.jt.xzzf.dubbo.xtba.xtgl.entity.YswgclVO;
import com.kdgcsoft.jt.xzzf.dubbo.xtba.xtgl.entity.YswgxwzpVO;

import java.util.List;

/**
 * @Description: 疑似违规车辆接口
 * @Author: zd
 * @Date: 2021/4/14
 */
public interface YswgclService {

    /**
     * 疑似违规车辆分页查询
     *
     * @param current
     * @param size
     * @param yswgclVO
     * @return
     */
    Page<YswgclVO> searchYswgclPage(long current, long size, YswgclVO yswgclVO);

    /**
     * 添加疑似违规行为数据，通过excel模板
     *
     * @param list    数据
     * @param fjJson  附件json数据
     * @param curUser
     */
    void drExcelForYswgcl(List<YswgclVO> list, String fjJson, SysUser curUser);

    /**
     * 根据主键id查询
     *
     * @param jsonStr
     * @return
     */
    List<YswgclVO> dcByYswgxwCheck(String jsonStr);

    /**
     * 根据查询条件导出
     *
     * @param yswgclVO
     * @return
     */
    List<YswgclVO> dcYswgxwBySearch(YswgclVO yswgclVO);

    /**
     * 根据主键id更新
     *
     * @param yswgxwzpVO
     */
    boolean updateWsgsglzpById(YswgxwzpVO yswgxwzpVO);

    /**
     * 附件上传
     *
     * @param yswgxwzpVO
     */
    void uploadFileYswgxw(YswgxwzpVO yswgxwzpVO);

    /**
     * 疑似违规行为综合统计查询
     *
     * @param current
     * @param size
     * @param yswgclVO
     * @return
     */
    Page<YswgclVO> searchYswgzhcxPage(long current, long size, YswgclVO yswgclVO);

    /**
     * 根据勾选查询数据
     *
     * @param ids
     * @return
     */
    List<YswgclVO> exportYswgclByCheck(String ids);

    /**
     * 根据查询条件查询数据
     *
     * @param yswgclVO
     * @return
     */
    List<YswgclVO> exportYswgclBySearch(YswgclVO yswgclVO);
}
