package com.kdgcsoft.jt.xzzf.dubbo.xtba.xtgl.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.dubbo.xtba.xtgl.entity.GsglVO;
import com.kdgcsoft.jt.xzzf.dubbo.xtba.xtgl.entity.GsglxxVO;
import com.kdgcsoft.jt.xzzf.dubbo.xtba.xtgl.entity.WsgsglzpVO;

import java.util.List;

/**
 * 外省高速公路数据处理接口
 *
 * @author zd
 * @since 2021-03-02
 */
public interface WsgsglzpService {

    /**
     * 根据ID获取信息
     *
     * @param id
     * @return
     */
    WsgsglzpVO getById(String id);

    /**
     * 分页查询外省高速公路数据
     * @param current
     * @param size
     * @param gsglVO
     * @return
     */
    Page<GsglxxVO> searchWsgsglxxPage(long current, long size, GsglVO gsglVO);

    /**
     * 根据多个主键id查询信息
     * @param ids
     * @return
     */
    List<GsglxxVO> searchByIds(String ids);

    /**
     * 根据查询条件查询信息
     * @param gsglVO
     * @return
     */
    List<GsglxxVO> searchByQuery(GsglVO gsglVO);

    /**
     * 外省高速公路数据手动分发
     * @param wsgsglzpVO
     * @return
     */
    boolean sdff(WsgsglzpVO wsgsglzpVO);

    /**
     * 外省高速公路数据自动分发
     * @param wsgsglzpVO
     * @return
     */
    boolean zdff(WsgsglzpVO wsgsglzpVO);

    /**
     * 市级退回分发
     * @param vo
     * @param ids
     * @return
     */
    boolean thff(WsgsglzpVO vo, String ids);

    /**
     * 省级撤回分发
     * @param vo
     * @param ids
     * @return
     */
    boolean chff(WsgsglzpVO vo, String ids);

    /**
     * 外省高速公路数据反馈
     * @param wsgsglzpVO
     * @return
     */
    boolean wsgsglFk(WsgsglzpVO wsgsglzpVO);

    /**
     * 更新外省高速公路指派信息(根据主键id)
     * @param wsgsglzpVO
     * @return
     */
    boolean updateWsgsglzpById(WsgsglzpVO wsgsglzpVO);
}

