package com.kdgcsoft.jt.xzzf.dubbo.xtba.xtgl.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.dubbo.xtba.xtgl.entity.Lhzcajxx;

import java.util.List;

/**
 * <p>
 * 服务类
 * 联合治超执法案件信息
 * </p>
 *
 * @author 董志刚
 * @since 2020-04-05
 */
public interface LhzcajxxService {

    /**
     * 新增信息
     *
     * @param lhzcajxx
     * @return
     */
    boolean insert(Lhzcajxx lhzcajxx);


    /**
     * 根据ID删除信息
     *
     * @param lhzcajxx
     * @return
     */
    boolean deleteById(Lhzcajxx lhzcajxx);

    /**
     * 根据ID获取信息
     *
     * @param id
     * @return
     */
    Lhzcajxx getById(String id);

    /**
     * 分页查询
     *
     * @param current  当前页
     * @param size     每页显示条数
     * @param lhzcajxx
     * @return
     */
    Page<Lhzcajxx> page(long current, long size, Lhzcajxx lhzcajxx);

    /**
     * 案号模糊查询
     *
     * @param lhzcajxx
     * @return
     */
    List<Lhzcajxx> searchah(Lhzcajxx lhzcajxx);

    /**
     * 车牌号模糊查询
     *
     * @param lhzcajxx
     * @return
     */
    List<Lhzcajxx> searchcph(Lhzcajxx lhzcajxx);

    /**
     * 修改附件
     *
     * @param lhzcajxx
     * @return
     */
    boolean updateByFjId(Lhzcajxx lhzcajxx);

    /**
     * 删除附件
     *
     * @param lhzcajxx
     * @return
     */
    boolean deleteFj(Lhzcajxx lhzcajxx);

    /**
     * 修改提交
     *
     * @param lhzcajxx
     * @return
     */
    boolean updateById(Lhzcajxx lhzcajxx);

    /**
     * 联网治超案件分页查询
     *
     * @param page
     * @param lhzcajxx
     * @return
     */
    Page<Lhzcajxx> searchLwzcajForPage(Page page, Lhzcajxx lhzcajxx);

    /**
     * 根据案件信息id查询治超案件
     *
     * @param ajxxId
     * @return
     */
    Lhzcajxx searchLwzcajByAjxxId(String ajxxId);

    /**
     * 最大编号
     *
     * @return
     */
    String findMaxBh();

    /**
     * 根据车牌号查询超限执法信息
     *
     * @param cph
     * @return
     */
    Lhzcajxx searchCxzfxxByCph(String cph);

    /**
     * 根据OrgId统计联合治超案件数量--用于首页Echarts图表
     *
     * @param lhzcajxx
     * @return
     */
    Integer getLhzcCountByOrgId(Lhzcajxx lhzcajxx);

    /**
     * 根据检测单号查询超限执法信息
     *
     * @param jcdh 检测单号
     * @return
     */
    Lhzcajxx searchCxzfxxByJcdh(String jcdh);

    /**
     * 根据主键id查询信息
     *
     * @param eventId
     * @return
     */
    Lhzcajxx searchById(String eventId);

    /**
     * 导出联合治超案件
     *
     * @param lhzcajxx
     * @return
     */
    List<Lhzcajxx> exportLhzcAjxx(Lhzcajxx lhzcajxx);
}

