package com.kdgcsoft.jt.xzzf.dubbo.xtba.xtgl.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;
import com.kdgcsoft.jt.xzzf.dubbo.xtba.xtgl.entity.GsglVO;
import com.kdgcsoft.jt.xzzf.dubbo.xtba.xtgl.entity.GsglxxVO;

import java.util.List;

/**
 * 高速公路数据接口
 *
 * @author zd
 * @since 2021-02-24
 */
public interface GsglxxService {

    /**
     * 分页查询
     *
     * @param current 当前页
     * @param size 每页显示条数
     * @param gsglVO
     * @return
     */
    Page<GsglVO> searchGsglxxPage(long current, long size, GsglVO gsglVO);

    /**
     * 根据ID获取信息
     *
     * @param id
     * @return
     */
    GsglxxVO getById(String id);

    /**
     * 新增抄告给外省的高速公路数据
     * @param gsglVO
     * @return
     */
    boolean addGsglxx(GsglVO gsglVO);

    /**
     * 根据gsglid查询出该抄告函中的高速公路数据
     * @param gsglid
     * @return
     */
    List<GsglxxVO> searchGsglListByGsglId(String gsglid);

    /**
     * 根据gsglid查询出该抄告函中的高速公路数据(分页)
     * @param current
     * @param size
     * @param gsglVO
     * @return
     */
    Page<GsglxxVO> searchGsglListByGsglIdPage(long current, long size, GsglVO gsglVO);

    /**
     * 根据gsglid更新XTBA_J_GSGL表
     * @param vo
     * @return
     */
    boolean updateGsglByGsglid(GsglVO vo);

    /**
     * 外省高速公路数据导入
     * @param gsglxxVO
     * @param curUser
     * @return
     */
    boolean addGsglxxByWsdr(GsglxxVO gsglxxVO, SysUser curUser);

}

