package com.kdgcsoft.jt.xzzf.dubbo.xtba.xtgl.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.dubbo.xtba.caseHandle.entity.AjxxVO;
import com.kdgcsoft.jt.xzzf.dubbo.xtba.xtgl.entity.Cgxx;

import java.text.ParseException;
import java.util.List;

public interface CgxxService {
    /**
     * 抄告外省初始化页面
     * @param current 当前页
     * @param size 分页条数
     * @param cgxx 查询条件
     * @return
     */
    Page<Cgxx> searchCgwsPage(long current, long size, Cgxx cgxx);

    /**
     * 案件选择初始化页面
     * @param current 当前页
     * @param size 分页条数
     * @param ajxxVO 查询条件
     * @return
     */
    Page<AjxxVO> searchAjxxPage(long current, long size, AjxxVO ajxxVO);

    /**
     * 通过jsjg匹配相应的jsjg
     * @param jsjg 接受单位
     * @return
     */
    List<Cgxx> searchJsjgByName(String jsjg);

    /**
     * 接收外省抄告初始化页面
     * @param current 当前页
     * @param size 分页条数
     * @param cgxx 查询条件
     * @return
     */
    Page<Cgxx> searchJswscgPage(long current, long size, Cgxx cgxx);

    /**
     * 抄告外省详情页面中获取(抄告函编号/接收单位/抄告时间/抄告单位)
     * @param ajcgxxid 案件抄告信息id
     * @return
     */
    Cgxx viewAjcg(String ajcgxxid);

    /**
     * 插入抄告外省信息到XTBA_J_CGXX
     * @param cgxx 插入的抄告外省信息
     * @return
     */
    Integer insertCgwsxxToCg(Cgxx cgxx);

    /**
     * 插入抄告外省信息到XTBA_J_CGAJ_GL
     * @param list
     * @param cgxx
     * @throws
     */
    void insertCgwsxxToGl(List<AjxxVO> list, Cgxx cgxx) throws ParseException;

    /**
     * 通过查询条件获取外省抄告信息
     * @param cgxx
     * @return
     */
    List<Cgxx> dcWscgxxBySearch(Cgxx cgxx);

    /**
     * 指派信息提交(外省抄告信息的修改)
     * @param list
     * @param jsOrgid
     * @param sm
     * @param zpsj
     */
    void zptjToCg(List<Cgxx> list, String jsOrgid, String sm, String zpsj);

    /**
     * 抄告外省详情页面(表格信息)
     * @param current
     * @param size
     * @param ajcgxxid
     * @return
     */
    Page<Cgxx>  getCgwsxxByClick(long current, long size, String ajcgxxid);

    /**
     * 外省抄告页面点击获取详细信息
     * @param cgajid
     * @return
     */
    Cgxx viewWsajcg(String cgajid);

    /**
     * 修改案件回复信息
     * @param cgxx
     */
    void updateAjhfxx(Cgxx cgxx);

    /**
     * 导出外省抄告信息(通过勾选)
     * @param list
     * @return
     */
    List<Cgxx> dcWscgxxByCheck(List<Cgxx> list);

    /**
     * 外省抄告回复页面详情
     * @param ajcgxxid
     * @return
     */
    Cgxx judgeExist(String ajcgxxid);

    /**
     * 根据传入的org_id去sys_org中获取org_name的值
     * @param orgid
     * @return
     */
    String getOrgNameById(String orgid);

    /**
     * 通过机构名称获取机构id
     * @param hfdw
     * @return
     */
    String searchOrgIdByName(String hfdw);

    /**
     * 通过勾选导出抄告外省信息
     * @param ajcgxxid
     * @return
     */
    List<Cgxx> dcwscgxx(String ajcgxxid);

    /**
     *导入excel信息到数据库中
     * @param list
     */
    void drxxByExcel(List<Cgxx> list,Cgxx cgxx);

    /**
     * 撤回指派
     * @param ajcgxxid
     */
    void chzp(String ajcgxxid);

    /**
     * 获取标题
     * @param ajcgxxid
     * @return
     */
    String getbt(String ajcgxxid);

    /**
     * 通过xzqhid获取xzqhmc
     * @param xzqhdm
     * @return
     */
    String getXzQhMCById(String xzqhdm);

    /**
     * 所属地获取车牌号
     * @param mc
     * @return
     */
    String searchCphByMc(String mc);

    /**
     * 自动指派提交
     * @param list
     */
    void zdzptj(List<Cgxx> list);
}