package com.kdgcsoft.jt.xzzf.dubbo.xtba.xtgl.entity;

import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
* @Description: 疑似违规行为指派
* @Author: zd
* @Date: 2021/4/15
*/
@Data
@TableName("XTBA_J_YSWGXWZP")
public class YswgxwzpVO extends BaseEntity<String> {

    private static final long serialVersionUID = 1L;

    /**
     * 主键id
     */
    @TableId
    private String yswgxwzpid;

    /**
     * 数据id
     */
    private String sjid;

    /**
     * 接收单位
     */
    private String jsdw;

    /**
     * 接受单位id
     */
    private String jsdwid;

    /**
     * 分发单位
     */
    private String zpdw;

    /**
     * 分发单位id
     */
    private String zpdwid;

    /**
     * 分发时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JSONField(format = "yyyy-MM-dd")
    private Date zpsj;

    /**
     * 分发说明
     */
    private String zpsm;

    /**
     * 处理结果
     */
    private String cljg;

    /**
     * 回复人id
     */
    private String hfrid;

    /**
     * 回复人
     */
    private String hfr;

    /**
     * 回复单位
     */
    private String hfdw;

    /**
     * 回复时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JSONField(format = "yyyy-MM-dd")
    private Date hfsj;

    /**
     * 回复状态
     */
    private String hfzt;

    /**
     * 回复单位id
     */
    private String hfdwid;

    /**
     * 分发批次
     */
    private String ffpc;

    /**
     * 处理方式
     */
    private String clfs;

    /**
     * 市级审核意见
     */
    private String sjshyj;

    /**
     * 市级撤回理由
     */
    private String sjchly;

    /**
     * 省级是否同意撤回反馈
     */
    private String sftych;

    /**
     * 市级退回分发理由
     */
    private String thffly;

    /**
     * 分发地市
     */
    private String ffds;

    /**
     * json字符串
     */
    @TableField(exist = false)
    private String jsonData;

    @TableField(exist = false)
    private String cxfw;

    /**
     *附件json
     */
    @TableField(exist = false)
    private String fjJson;
    /**
     * 存储材料路径
     */
    @TableField(exist = false)
    private List bcljArr = new ArrayList();
    /**
     * 存储材料名称
     */
    @TableField(exist = false)
    private List clmcArr = new ArrayList();
    /**
     * 存储附件id
     */
    @TableField(exist = false)
    private List fjidArr = new ArrayList();
    /**
     * 分发日期数组
     */
    @TableField(exist = false)
    private String[] zpsjArr;
    /**
     * 指派时间开始
     */
    @TableField(exist = false)
    private String zpsjQi;
    /**
     * 指派时间结束
     */
    @TableField(exist = false)
    private String zpsjZhi;
    /**
     * 回复时间数组
     */
    @TableField(exist = false)
    private String[] hfsjArr;
    /**
     * 回复时间开始
     */
    @TableField(exist = false)
    private String hfsjQi;
    /**
     * 回复时间结束
     */
    @TableField(exist = false)
    private String hfsjZhi;
    /**
     * 分发接收单位id
     */
    @TableField(exist = false)
    private String ffjsdwid;
    /**
     * 标识
     */
    @TableField(exist = false)
    private String flag;
    /**
     * 车牌号
     */
    @TableField(exist = false)
    private String cphm;
    /**
     * 当事人名称
     */
    @TableField(exist = false)
    private String dsmc;
    /**
     * 企业名称
     */
    @TableField(exist = false)
    private String qymc;
    /**
     * 状态
     */
    @TableField(exist = false)
    private String zt;
    /**
     * 反馈日期
     */
    @TableField(exist = false)
    private String hfsjStr;

    @Override
    public String getId() {
        return yswgxwzpid;
    }

    @Override
    public void setId(String id) {
        this.yswgxwzpid = id;
    }

}
