package com.kdgcsoft.jt.xzzf.dubbo.xtba.xtgl.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 外省高速公路数据处理
 *
 * @author zd
 * @since 2021-03-02
 */
@Data
@TableName("XTBA_J_WSGSGLZP")
public class WsgsglzpVO extends BaseEntity<String> {

    private static final long serialVersionUID = 1L;

    /**
     * 主键id
     */
    @TableId
    private String wsgsglzpid;

    /**
     * 接收单位
     */
    private String jsdw;

    /**
     * 接受单位id
     */
    private String jsdwid;
    /**
     * 分发接收单位id
     */
    @TableField(exist = false)
    private String ffjsdwid;

    /**
     * 分发单位
     */
    private String zpdw;

    /**
     * 分发单位id
     */
    private String zpdwid;

    /**
     * 分发时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date zpsj;

    /**
     * 分发说明
     */
    private String zpsm;

    /**
     * 处理结果
     */
    private String cljg;

    /**
     * 回复人id
     */
    private String hfrid;

    /**
     * 回复人
     */
    private String hfr;

    /**
     * 回复单位
     */
    private String hfdw;

    /**
     * 回复时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date hfsj;

    /**
     * 回复状态
     */
    private String hfzt;

    /**
     * 回复单位id
     */
    private String hfdwid;

    /**
     * 分发批次
     */
    private String ffpc;

    /**
     * 处理方式
     */
    private String clfs;

    /**
     * 市级审核意见
     */
    private String sjshyj;

    /**
     * 市级撤回理由
     */
    private String sjchly;

    /**
     * 省级是否同意撤回反馈
     */
    private String sftych;

    /**
     * 市级退回分发理由
     */
    private String thffly;

    /**
     * 分发地市
     */
    private String ffds;

    /**
     * 高速公路数据信息id
     */
    private String gsglxxid;

    /**
     * json字符串
     */
    @TableField(exist = false)
    private String jsonData;
    /**
     * 标识
     */
    @TableField(exist = false)
    private String flag;

    @TableField(exist = false)
    private String cxfw;
    /**
     * 入口时间起止
     */
    @TableField(exist = false)
    private String[] rksjArr;
    @TableField(exist = false)
    private String rksjQi;
    @TableField(exist = false)
    private String rksjZhi;
    /**
     * 检测时间起止
     */
    @TableField(exist = false)
    private String[] jcsjArr;
    @TableField(exist = false)
    private String jcsjQi;
    @TableField(exist = false)
    private String jcsjZhi;
    /**
     * 入口省份
     */
    @TableField(exist = false)
    private String rksf;
    /**
     * 是否是大件
     */
    @TableField(exist = false)
    private String[] sfdjysclArr;

    /**
     *附件json
     */
    @TableField(exist = false)
    private String fjJson;
    /**
     * 存储材料路径
     */
    @TableField(exist = false)
    private List bcljArr = new ArrayList();
    /**
     * 存储材料名称
     */
    @TableField(exist = false)
    private List clmcArr = new ArrayList();
    /**
     * 存储附件id
     */
    @TableField(exist = false)
    private List fjidArr = new ArrayList();


    @Override
    public String getId() {
        return wsgsglzpid;
    }

    @Override
    public void setId(String id) {
        this.wsgsglzpid = id;
    }

}
