package com.kdgcsoft.jt.xzzf.dubbo.xtba.xtgl.entity;

import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * <p>
 * 联合治超执法案件信息
 * </p>
 *
 * @author 董志刚
 * @since 2020-04-05
 */
@Data
@TableName("XTBA_J_LHZCAJXX")
public class Lhzcajxx extends BaseEntity<String> {

    private static final long serialVersionUID = 1L;

    /**
     * 联合治超案件信息ID
     */
    @TableId
    private String lhzcajxxid;

    /**
     * 检测时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JSONField(format = "yyyy-MM-dd")
    private Date jcsj;

    @TableField(exist = false)
    private String jcsjStr;

    /**
     * 治超站编码
     */
    private String zczbm;

    /**
     * 交警扣分
     */
    private String jjkf;

    /**
     * 罚款
     */
    private String fk;

    /**
     * 道路运输证核发单位
     */
    private String dlyszhfdw;

    /**
     * 办理状态
     */
    @TableField(exist = false)
    private String workitemname;

    /**
     * 从业资格证核发单位
     */
    private String cyzgzhfdw;

    /**
     * 从业资格证核发地
     */
    private String cyzgzhfd;

    /**
     * 车籍地点
     */
    private String cjdd;

    /**
     * 车牌号
     */
    private String cph;

    /**
     * 吨 车辆限重
     */
    private Double clxz;

    /**
     * 吨  卸载前车货总重
     */
    private Double xzqchzz;

    /**
     * 吨  卸载后车货总重
     */
    private Double xzhchzz;

    /**
     * 超限率
     */
    private Double cxl;

    /**
     * 驾驶员姓名
     */
    private String jsyxm;

    /**
     * 驾驶证号
     */
    private String jszh;

    /**
     * 身份证号
     */
    private String sfzh;

    /**
     * 道路运输证号
     */
    private String dlyszh;

    /**
     * 从业资格证号
     */
    private String cyzgzh;

    /**
     * 车辆运输企业
     */
    private String clysqy;

    /**
     * 车辆运输企业统一社会信用代码
     */
    private String clysqytyshxydm;

    /**
     * 经营许可证号
     */
    private String jyxkzh;

    /**
     * 车辆装载货厂
     */
    private String clzzhc;

    /**
     * 案号
     */
    private String ah;

    /**
     * 货物源头区域
     */
    private String hwytqy;

    /**
     * 源头单位名称
     */
    private String ytdwmc;

    /**
     * 源头单位负责人
     */
    private String ytdwfzr;

    /**
     * 源头单位地址
     */
    private String ytdwdz;

    /**
     * 源头单位联系方式
     */
    private String ytdwlxfs;

    /**
     * 货物名称
     */
    private String hwmc;

    /**
     * 货物类别
     */
    private String hwlb;

    /**
     * 移送时间
     */
    private Date yssj;

    /**
     * 接收机构
     */
    private String jsjg;

    /**
     * 移送机构
     */
    private String ysjg;

    /**
     * 立卷时间
     */
    private Date ljsj;

    /**
     * 归档时间
     */
    private Date gdsj;

    /**
     * 立卷人
     */
    private String ljr;

    /**
     * 归档标识
     */
    private String gdbs;

    /**
     * 存档期限
     */
    private String cdqx;

    /**
     * 机构ID
     */
    private String jgid;

    /**
     * 状态
        01超限信息获取
        02案件文书制作
        03案件归档
        04已归档
     */
    private String zt;


    /**
     * 00未删除01已删除
     */
    private String deleteFlag;

    /**
     * 案发时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date afsj;

    @TableField(exist = false)
    private String afsjStart;

    @TableField(exist = false)
    private String afsjEnd;

    @TableField(exist = false)
    private String afsjStr;

    /**
     * 创建日期
     */
    @JSONField(format = "yyyy年MM月dd日")
    @TableField(exist = false)
    private Date cjrq;
    @TableField(exist = false)
    private String cjrqStart;

    @TableField(exist = false)
    private String cjrqEnd;

    @TableField(exist = false)
    private String cjrqStr;

    /**
     * 治超站点
     */
    private String zczd;

    /**
     * 编号
     */
    private String bh;

    /**
     * 车轴数
     */
    private Long czs;

    /**
     * 超限重量
     */
    private Double cxzl;

    /**
     * 车辆装货场所
     */
    private String clzhcs;

    /**
     * 检测单号
     */
    private String jcdh;

    /**
     * 附件id 从前台接收一个投诉举报信息所包含的附件id
     */
    @TableField(exist = false)
    private String[] fjid;

    /**
     * 材料名称
     */
    @TableField(exist = false)
    private String clmc;
    /**
     * 保存路径
     */
    @TableField(exist = false)
    private String bclj;
    /**
     * 存储材料路径
     */
    @TableField(exist = false)
    private List bcljArr=new ArrayList();
    /**
     * 存储材料名称
     */
    @TableField(exist = false)
    private List clmcArr=new ArrayList();
    /**
     * 存储附件id
     */
    @TableField(exist = false)
    private List fjidArr=new ArrayList();

    /**
     * 案件信息id
     */
    @TableField(exist = false)
    private String ajxxid;

    /**
     * 案件信息id
     */
    @TableField(exist = false)
    private String cxjcdh;

    /**
     * 车辆超限率
     */
    @TableField(exist = false)
    private String clcxl;

    /**
     * 组织机构id
     */
    @TableField(exist = false)
    private String orgId;

    /**
     * 案件状态数组
     */
    @TableField(exist = false)
    private String[] ajztArray;


    private Long mainProcessInstId;

    /**
     * 工作流id
     */
    private Long gzlid;

    /**
     * 环节id
     */
    @TableField(exist = false)
    private String hjid;

    /**
     * 环节定义id
     */
    @TableField(exist = false)
    private String hddyid;

    /**
     * 环节名称
     */
    @TableField(exist = false)
    private String hjmc;

    //查询条件日期
    @TableField(exist = false)
    private String rq;

    @TableField(exist = false)
    private String rqStr;

    @TableField(exist = false)
    private String rqEnd;

    @TableField(exist = false)
    private String ajlx;

    @TableField(exist = false)
    private String cxfw;

    @TableField(exist = false)
    private String[] ztArr;

    /**
     * 办理时间
     */
    @JSONField(format = "yyyy年MM月dd日")
    @TableField(exist = false)
    private Date blrq;



    /**
     * 处理机构
     */
    @TableField(exist = false)
    private String cljg;

    @Override
    public String getId() {
        return lhzcajxxid;
    }

    @Override
    public void setId(String id) {
        this.lhzcajxxid = id;
    }


}
