package com.kdgcsoft.jt.xzzf.dubbo.xtba.xtgl.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 高速公路信息实体类
 *
 * @author zd
 * @since 2021-02-24
 */
@Data
@TableName("XTBA_J_GSGLXX")
public class GsglxxVO extends BaseEntity<String> {

    private static final long serialVersionUID = 1L;

    /**
     * 主键id
     */
    @TableId
    private String gsglxxid;

    private String gsglid;

    /**
     * 入口省份
     */
    private String rksf;

    /**
     * 入口收费站名称
     */
    private String rksfzmc;

    /**
     * 入口时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date rksj;
    @TableField(exist = false)
    private String rksjStr;

    /**
     * 入口总重（kg）
     */
    private String rkzz;

    /**
     * 入口轴数
     */
    private String rkzs;

    /**
     * 省简称
     */
    private String sjc;

    /**
     * 车牌颜色
     */
    private String cpys;

    /**
     * 实际车牌号
     */
    private String sjcph;

    /**
     * 所属地市
     */
    private String ssds;

    /**
     * 出口收费站名称
     */
    private String cksfzmc;

    /**
     * 检测时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date jcsj;
    @TableField(exist = false)
    private String jcsjStr;

    /**
     * 车货总质量（kg）
     */
    private String chzzl;

    /**
     * 车辆轴数
     */
    private String czs;

    /**
     * 最大允许质量（kg）
     */
    private String zdyxzl;

    /**
     * 超限量（kg）
     */
    private String cxl;

    /**
     * 是否为大件运输车辆
     */
    private String sfdjyscl;

    /**
     * 超限率
     */
    private String cxlv;

    /**
     * 备注
     */
    private String bz;

    /**
     * 数据来源（01：省内，02：省外）
     */
    private String sjly;

    /**
     * 抄告函编号
     */
    @TableField(exist = false)
    private String cghbh;

    @TableField(exist = false)
    private String wsgsglzpid;

    /**
     * 抄告时间
     */
    @TableField(exist = false)
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date cgsj;
    /**
     * 接收机构id
     */
    @TableField(exist = false)
    private String jsjgid;
    /**
     * 接收机构
     */
    @TableField(exist = false)
    private String jsjg;
    /**
     * 抄告机构id
     */
    @TableField(exist = false)
    private String cgdwid;
    /**
     * 抄告单位
     */
    @TableField(exist = false)
    private String cgdw;
    /**
     * 标题
     */
    @TableField(exist = false)
    private String bt;
    /**
     * json字符串
     */
    @TableField(exist = false)
    private String jsonData;
    /**
     * 接受单位
     */
    @TableField(exist = false)
    private String jsdw;
    /**
     * 分发日期
     */
    @TableField(exist = false)
    private String zpsjStr;
    /**
     * 反馈日期
     */
    @TableField(exist = false)
    private String hfsjStr;
    /**
     * 分发批次
     */
    @TableField(exist = false)
    private String ffpc;
    /**
     * 状态
     */
    @TableField(exist = false)
    private String zt;
    /**
     * 接受单位id
     */
    @TableField(exist = false)
    private String jsdwid;
    /**
     * 分发单位
     */
    @TableField(exist = false)
    private String zpdw;
    /**
     * 分发单位id
     */
    @TableField(exist = false)
    private String zpdwid;
    /**
     * 分发说明
     */
    @TableField(exist = false)
    private String zpsm;
    /**
     * 处理结果
     */
    @TableField(exist = false)
    private String cljg;
    /**
     * 回复人id
     */
    @TableField(exist = false)
    private String hfrid;
    /**
     * 回复人
     */
    @TableField(exist = false)
    private String hfr;
    /**
     * 回复单位
     */
    @TableField(exist = false)
    private String hfdw;
    /**
     * 回复单位id
     */
    @TableField(exist = false)
    private String hfdwid;
    /**
     * 处理方式
     */
    @TableField(exist = false)
    private String clfs;
    /**
     * 市级审核意见
     */
    @TableField(exist = false)
    private String sjshyj;
    /**
     * 市级撤回理由
     */
    @TableField(exist = false)
    private String sjchly;
    /**
     * 省级是否同意撤回反馈
     */
    @TableField(exist = false)
    private String sftych;
    /**
     * 市级退回分发理由
     */
    @TableField(exist = false)
    private String thffly;
    /**
     * 分发地市
     */
    @TableField(exist = false)
    private String ffds;

    /**
     * 是否上传附件
     */
    @TableField(exist = false)
    private String sfscfj;

    /**
     *附件json
     */
    @TableField(exist = false)
    private String fjJson;
    /**
     * 存储材料路径
     */
    @TableField(exist = false)
    private List bcljArr = new ArrayList();
    /**
     * 存储材料名称
     */
    @TableField(exist = false)
    private List clmcArr = new ArrayList();
    /**
     * 存储附件id
     */
    @TableField(exist = false)
    private List fjidArr = new ArrayList();
    /**
     * 机构等级
     */
    @TableField(exist = false)
    private String orgLevel;

    @Override
    public String getId() {
        return gsglxxid;
    }

    @Override
    public void setId(String id) {
        this.gsglxxid = id;
    }

}
