package com.kdgcsoft.jt.xzzf.dubbo.xtba.xtgl.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 高速公路抄告实体类
 *
 * @author zd
 * @since 2021-02-24
 */
@Data
@TableName("XTBA_J_GSGL")
public class GsglVO extends BaseEntity<String> {

    private static final long serialVersionUID = 1L;

    /**
     * 主键id
     */
    @TableId
    private String gsglid;

    /**
     * 抄告函编号
     */
    private String cghbh;

    /**
     * 抄告时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date cgsj;
    @TableField(exist = false)
    private String cgsjStr;

    /**
     * 接收机构id
     */
    private String jsjgid;

    /**
     * 接收机构
     */
    private String jsjg;

    /**
     * 抄告机构id
     */
    private String cgdwid;

    /**
     * 抄告单位
     */
    private String cgdw;

    /**
     * 标题
     */
    private String bt;

    /**
     * json字符串
     */
    @TableField(exist = false)
    private String jsonData;

    /**
     * 是否上传附件
     */
    @TableField(exist = false)
    private String sfscfj;

    /**
     *附件json
     */
    @TableField(exist = false)
    private String fjJson;
    /**
     * 存储材料路径
     */
    @TableField(exist = false)
    private List bcljArr = new ArrayList();
    /**
     * 存储材料名称
     */
    @TableField(exist = false)
    private List clmcArr = new ArrayList();
    /**
     * 存储附件id
     */
    @TableField(exist = false)
    private List fjidArr = new ArrayList();

    /**
     * 入口时间起止
     */
    @TableField(exist = false)
    private String[] rksjArr;
    @TableField(exist = false)
    private String rksjQi;
    @TableField(exist = false)
    private String rksjZhi;
    /**
     * 检测时间起止
     */
    @TableField(exist = false)
    private String[] jcsjArr;
    @TableField(exist = false)
    private String jcsjQi;
    @TableField(exist = false)
    private String jcsjZhi;
    /**
     * 是否是大件
     */
    @TableField(exist = false)
    private String[] sfdjysclArr;
    /**
     * 接收单位id
     */
    @TableField(exist = false)
    private String jsdwid;
    /**
     * 分发接收单位id
     */
    @TableField(exist = false)
    private String ffjsdwid;
    /**
     * 入口省份
     */
    @TableField(exist = false)
    private String rksf;
    /**
     * 查询范围
     */
    @TableField(exist = false)
    private String cxfw;
    /**
     * 状态
     */
    @TableField(exist = false)
    private String zt;

    @Override
    public String getId() {
        return gsglid;
    }

    @Override
    public void setId(String id) {
        this.gsglid = id;
    }


}
