package com.kdgcsoft.jt.xzzf.dubbo.xtba.xtgl.entity;

import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * 超限执法信息实体类
 *
 * @author zd
 * @since 2020-06-30
 */
@Data
@TableName("XTBA_J_CXZFXX")
public class CxzfxxVO {

    private static final long serialVersionUID = 1L;

    /**
     * 超限执法信息id
     */
    @TableId
    private String chaoXianZhiFaXinXiId;

    /**
     * 案号
     */
    private String anHao;

    /**
     * 案由
     */
    private String anYou;

    /**
     * 案件状态数组
     */
    @TableField(exist = false)
    private String[] ajztArray;

    @TableField(exist = false)
    private String zt;

    @TableField(exist = false)
    private String ah;

    /**
     * 案发时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date afsj;

    @TableField(exist = false)
    private String afsjStart;

    @TableField(exist = false)
    private String afsjEnd;

    @TableField(exist = false)
    private String ajztflag;

    /**
     * 立案时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date liAnShiJian;

    /**
     * 结案时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date jieAnShiJian;

    /**
     * 车辆车牌号
     */
    private String cheLiangChePaiHao;

    /**
     * 检测单号
     */
    private String jianCeDanHao;

    /**
     * 道路运输证号
     */
    private String daoLuYunShuZhengHao;

    /**
     * 法人代表姓名
     */
    private String faRenDaiBiaoXingMing;

    /**
     * 证件类型
     */
    private String zhengJianLeiXing;

    /**
     * 法人代表证件号码
     */
    private String faRenDaiBiaoZhengJhm;

    /**
     * 司机姓名
     */
    private String siJiXingMing;

    /**
     * 驾驶证号
     */
    private String jiaShiZhengHao;

    /**
     * 从业资格证号
     */
    private String congYeZiGeZhengHao;

    /**
     * 货物名称
     */
    private String huoWuMingCheng;

    /**
     * 处罚结果
     */
    private String chuFaJieGuo;

    /**
     * 货物类别
     */
    private String huoWuLeiBie;

    /**
     * 处罚书号
     */
    private String chuFaShuHao;

    /**
     * 处罚日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date chuFaRiQi;

    /**
     * 罚款金额
     */
    private String faKuanJinE;

    /**
     * 赔偿金额
     */
    private Double peiChangJinE;

    /**
     * 执法单位
     */
    private String zhiFaDanWei;

    /**
     * 备注
     */
    private String beiZhu;

    /**
     * 业户名称
     */
    private String yeHuMingCheng;

    /**
     * 车货总重（卸载后）
     */
    private Double cheHuoZongZhong;
    /**
     * 车货总重（卸载后）
     */
    private Double cheHuoZongZhong1;

    /**
     * 超限率
     */
    private Double chaoXianLv;

    /**
     * 处罚地区
     */
    private String chuFaDiQu;

    /**
     * 轴数
     */
    private Long zhouShu;

    /**
     * 货源地
     */
    private String hyd;

    /**
     * 源头单位
     */
    private String ytdw;

    /**
     * 源头单位地址
     */
    private String ytdwdz;

    /**
     * 源头单位负责人
     */
    private String ytdwfzr;

    /**
     * 源头单位联系方式
     */
    private String ytdwlxfs;

    /**
     * 车长
     */
    private Double cheChang;

    /**
     * 车宽
     */
    private Double cheKuan;

    /**
     * 车高
     */
    private Double cheGao;

    /**
     * 超长
     */
    private Double chaoChang;

    /**
     * 超宽
     */
    private Double chaoKuan;

    /**
     * 超高
     */
    private Double chaoGao;

    /**
     * 处罚决定书图片
     */
    private String chuFaJueDingShuTuPian;

    /**
     * 处罚决定书图片
     */
    private String chuFaJueDingShuTuPiant;

    private String dlzsDw;

    private String cyzsDw;

    /**
     * 检测时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date jianCeShiJian;

    /**
     * 限重
     */
    private Double xianZhong;

    /**
     * 行政区划
     */
    private String xzqh;

    /**
     * 车籍地
     */
    private String cjd;

    private String cyzsHfd;

    private String isuploadzd;

    private String odsid;

    /**
     * 承运人名称
     */
    private String chengYunRenMingCheng;

    /**
     * 图片路径
     */
    private String tuPian1LuJing;

    private String tuPian2LuJing;

    /**
     * 颜色
     */
    private String yanSe;

    /**
     * 图片详细路径
     */
    private String tuPian1XiangXiLuJing;

    private String tuPian2XiangXiLuJing;

    private String shiJianIdDlysz;

    private String shiJianIdCyzgz;

    private String dlzsDwId;

    private String cyzsDwId;

    private String cjdId;

    private String cyzsHfdId;

    /**
     * 卸载前总重
     */
    @TableField(exist = false)
    private String xieZaiQianZongZhong;

    /**
     * 卸载后总重
     */
    @TableField(exist = false)
    private String zieZaiHouZongZhong;

}
