package com.kdgcsoft.jt.xzzf.dubbo.xtba.xtgl.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * <p>
 * ０１待回复
 * ０２已回复
 * </p>
 *
 * @author zhaokai
 * @since 2020-08-27
 */
@Data
@TableName("XTBA_J_WSCGZP")
public class Cgzp extends BaseEntity<String> {

    private static final long serialVersionUID = 1L;

    @TableId
    private String wscgzpid;

    private String jsdw;

    private String jsdwid;
    /**
     * 分发接收单位id
     */
    @TableField(exist = false)
    private String ffjsdwid;

    private String zpdw;

    private String zpdwid;

    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date zpsj;

    private String zpsm;

    private String cljg;

    private String hfrid;

    private String hfr;

    private String hfdw;

    private Date hfsj;

    private String hfzt;

    /**
     * 分发批次
     *
     * @return
     */
    private String ffpc;
    /**
     * 处理方式
     *
     * @return
     */
    private String clfs;
    /**
     * 市级审核意见
     *
     * @return
     */
    private String sjshyj;
    /**
     * 市级撤回理由
     *
     * @return
     */
    private String sjchly;
    /**
     * 省级是否同意撤回反馈
     *
     * @return
     */
    private String sftych;
    /**
     * 市级退回分发理由
     *
     * @return
     */
    private String thffly;
    /**
     * 分发地市
     *
     * @return
     */
    private String ffds;
    /**
     * 反馈备注
     *
     * @return
     */
    private String hfbz;


    /**
     * 指派时间Str
     *
     * @return
     */
    @TableField(exist = false)
    private String zpsjStr;

    /**
     * 案件信息json
     *
     * @return
     */
    @TableField(exist = false)
    private String exportJson;

    /**
     * 案件抄告信息id
     *
     * @return
     */
    @TableField(exist = false)
    private String ajcgxxid;

    /**
     * 回复单位id
     *
     * @return
     */
    private String hfdwid;

    /**
     * 回复时间str
     *
     * @return
     */
    @TableField(exist = false)
    private String hfsjStr;

    /**
     * 附加json
     *
     * @return
     */
    @TableField(exist = false)
    private String fjJson;

    /**
     *
     */
    @TableField(exist = false)
    private String flag;

    /**
     * 车船号
     */
    @TableField(exist = false)
    private String cch;
    @TableField(exist = false)
    private String cxfw;
    @TableField(exist = false)
    private String[] zpsjArr;
    @TableField(exist = false)
    private String ay;
    @TableField(exist = false)
    private String ysqymc;
    @TableField(exist = false)
    private String[] hfsjArr;
    /**
     * 回复时间开始
     */
    @TableField(exist = false)
    private String hfsjSta;
    /**
     * 回复时间结束
     */
    @TableField(exist = false)
    private String hfsjEnd;
    /**
     * 指派时间开始
     */
    @TableField(exist = false)
    private String zpsjSta;
    /**
     * 指派时间结束
     */
    @TableField(exist = false)
    private String zpsjEnd;

    @Override
    public String getId() {
        return wscgzpid;
    }

    @Override
    public void setId(String id) {
        this.wscgzpid = id;
    }
}
