package com.kdgcsoft.jt.xzzf.dubbo.xtba.xtgl.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;
import java.util.Date;

@Data
@TableName("XTBA_J_CGXX")
public class Cgxx extends BaseEntity<String> {

    private static final long serialVersionUID = 1L;

    /**
     * AJCGXXID
     */
    @TableId
    private String ajcgxxid;

    /**
     * 抄告函编号
     */
    private String cghbh;

    /**
     * 抄告时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date cgsj;

    /**
     * 接收机构ID
     */
    private String jsjgid;

    /**
     * 接收机构
     */
    private String jsjg;

    /**
     * 抄告单位ID
     */
    private String cgdwid;

    /**
     * 抄告单位
     */
    private String cgdw;

    /**
     * 开始抄告时间
     * @return
     */
    @TableField(exist = false)
    private String cgsjSta;

    /**
     * 结束抄告时间
     * @return
     */
    @TableField(exist = false)
    private String cgsjEnd;

    /**
     * 抄告时间Str
     * @return
     */
    @TableField(exist = false)
    private String cgsjStr;

    /**
     * 案号
     * @return
     */
    @TableField(exist = false)
    private String ah;

    /**
     * 车船号
     * @return
     */
    @TableField(exist = false)
    private String cch;

    /**
     * 案由
     * @return
     */
    @TableField(exist = false)
    private String ay;

    /**
     * 业户名称
     * @return
     */
    @TableField(exist = false)
    private String dcry1jgmc;

    /**
     * 抄告地点
     * @return
     */
    @TableField(exist = false)
    private String cjdd;

    /**
     *车籍地点
     * @return
     */
    @TableField(exist = false)
    private String ccjd;

    /**
     * 立案时间Str
     * @return
     */
    @TableField(exist = false)
    private String lasjStr;

    /**
     * 立案时间
     * @return
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @TableField(exist = false)
    private Date lasj;

    /**
     * 案件状态代码
     * @return
     */
    @TableField(exist = false)
    private String ajztdm;

    /**
     * 车牌号码
     * @return
     */
    @TableField(exist = false)
    private String cphm;

    /**
     * 道路运输证号
     * @return
     */
    @TableField(exist = false)
    private String dlyszh;

    /**
     * 结案时间
     * @return
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @TableField(exist = false)
    private Date jasj;

    /**
     * 结案时间Str
     * @return
     */
    @TableField(exist = false)
    private String jasjStr;

    /**
     * 案件信息json字符串
     * @return
     */
    @TableField(exist = false)
    private String ajxxJson;


    /**
     * 删除状态
     */
    private String deleteFlag;

    /**
     * cgajid
     */
    @TableField(exist = false)
    private String cgajid;

    /**
     * ajcgxxid数组
     */
    @TableField(exist = false)
    private String[] ajcgxxids;

    /**
     * ajxxid
     */
    @TableField(exist = false)
    private String ajxxid;

    /**
     * 当事人名称
     */
    @TableField(exist = false)
    private String dsrmc;

    /**
     * 从业资格证号
     */
    @TableField(exist = false)
    private String cyzgzh;

    /**
     * 车辆运输证号
     */
    @TableField(exist = false)
    private String clyyz;

    /**
     * 受案机构名称
     */
    @TableField(exist = false)
    private String sajgmc;

    /**
     * 执法单位联系人
     */
    @TableField(exist = false)
    private String dcryxm1;

    /**
     * 当事人单位
     */
    @TableField(exist = false)
    private String dsrdw;

    /**
     * 处理结果
     */
    @TableField(exist = false)
    private String cljg;

    /**
     * 回复人
     */
    @TableField(exist = false)
    private String hfr;

    /**
     * 回复单位
     */
    @TableField(exist = false)
    private String hfdw;

    /**
     * 回复时间
     */
    @TableField(exist = false)
    private String hfsj;

    /**
     * 回复时间Str
     */
    @TableField(exist = false)
    private String hfsjStr;

    /**
     * 回复状态
     */
    @TableField(exist = false)
    private String hfzt;

    /**
     * 驾驶员
     */
    @TableField(exist = false)
    private String jsy;

    /**
     * 运输企业名称
     */
    @TableField(exist = false)
    private String ysqymc;

    /**
     * 处罚案卷号
     */
    @TableField(exist = false)
    private String cfajh;

    /**
     * 处罚决定时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @TableField(exist = false)
    private Date cfjdsj;

    /**
     * 处罚决定时间str
     */
    @TableField(exist = false)
    private String cfjdsjStr;

    /**
     * 违法获取时间
     */
    @TableField(exist = false)
    private String wfhqsjStr;

    /**
     * 处罚金额
     */
    @TableField(exist = false)
    private String cfje;

    /**
     * 执法单位
     */
    @TableField(exist = false)
    private String zfdw;

    /**
     * 执法单位联系人
     */
    @TableField(exist = false)
    private String zfdwlxr;

    /**
     * 执法单位联系电话
     */
    @TableField(exist = false)
    private String zfdwlxdh;

    /**
     * 违法事实
     */
    @TableField(exist = false)
    private String wfss;

    /**
     * 说明
     */
    @TableField(exist = false)
    private String sm;

    /**
     * 业户名称
     */
    @TableField(exist = false)
    private String yhmc;

    /**
     *组织机构的org_id
     */
    @TableField(exist = false)
    private String orgid;

    /**
     *指派时间Str
     */
    @TableField(exist = false)
    private String zpsjStr;

    /**
     *指派时间
     */
    @TableField(exist = false)
    private Date zpsj;

    /**
     *指派单位
     */
    @TableField(exist = false)
    private String zpdw;

    /**
     *接收单位
     */
    @TableField(exist = false)
    private String jsdw;

    /**
     *指派说明
     */
    @TableField(exist = false)
    private String zpsm;

    /**
     *案件来源
     */
    @TableField(exist = false)
    private String ajlydm;

    /**
     *违法状态
     */
    @TableField(exist = false)
    private String wfzt;

    /**
     *车牌号码算出的地址
     */
    @TableField(exist = false)
    private String xzqhid;

    /**
     *标题
     */
    private String bt;

    /**
     *机构名称
     */
    @TableField(exist = false)
    private String orgName;

    /**
     *查询范围
     */
    @TableField(exist = false)
    private String cxfw;

    @Override
    public String getId() {
        return ajcgxxid;
    }

    @Override
    public void setId(String id) {
        this.ajcgxxid = id;
    }
}
