package com.kdgcsoft.jt.xzzf.dubbo.xtba.taskManage.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.dubbo.xtba.taskManage.entity.XcjbjlVO;
import com.kdgcsoft.jt.xzzf.dubbo.xtba.taskManage.entity.XcrzVO;

import java.util.List;

/**
 * <p>
 * 服务类
 * </p>
 *
 * @author zd
 * @since 2020-02-17
 */
public interface XcrzService {

    /**
     * 根据ID删除信息
     *
     * @param id
     * @param xcrzVO
     * @return
     */
    boolean deleteById(String id, XcrzVO xcrzVO);

    /**
     * 根据ID获取信息
     *
     * @param id
     * @return
     */
    XcrzVO getById(String id);


    /**
     * 分页查询
     *
     * @param current 当前页
     * @param size    每页显示条数
     * @param xcrzVO
     * @return
     */
    Page<XcrzVO> page(long current, long size, XcrzVO xcrzVO);

    /**
     * 获取当前日期，巡查计划个数
     *
     * @param xcrzbh
     * @return
     */
    int countCurrentDate(String xcrzbh);

    /**
     * 新增
     *
     * @param xcrzVO
     * @return
     */
    boolean addXcrz(XcrzVO xcrzVO);

    /**
     * 修改
     *
     * @param xcrzVO
     * @return
     */
    boolean updateXcrz(XcrzVO xcrzVO);

    /**
     * 巡查交接记录
     *
     * @param xcrzid
     * @return
     */
    XcjbjlVO getXcjbjlById(String xcrzid);

    /**
     * 巡查日志导出
     *
     * @param exportJson
     */
    List<XcrzVO> daochuBycheck(String exportJson);

    /**
     * 查询导出
     *
     * @param xcrzVO
     * @return
     */
    List<XcrzVO> daochuBySearch(XcrzVO xcrzVO);

    XcjbjlVO searchXcrz(String xcrzid);

    /**
     * 根据巡查日志id，查询巡查日志
     *
     * @param xcrzid
     * @return
     */
    XcrzVO searchXcrzByXcrzid(String xcrzid);
}

