package com.kdgcsoft.jt.xzzf.dubbo.xtba.taskManage.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.common.component.ComboboxVo;
import com.kdgcsoft.jt.xzzf.dubbo.xtba.taskManage.entity.XcryVO;

import java.util.List;

/**
 * 巡查人员服务类
 *
 * @author zd
 * @since 2020-02-11
 */
public interface XcryService {

    /**
     * 新增信息
     *
     * @param xcryVO
     * @return
     */
    boolean insert(XcryVO xcryVO);

    /**
     * 修改信息
     *
     * @param xcryVO
     * @return
     */
    boolean updateById(XcryVO xcryVO);

    /**
     * 根据ID删除信息
     *
     * @param id　ID
     * @return
     */
    boolean deleteById(String id);

    /**
     * 根据ID获取信息
     *
     * @param id
     * @return
     */
    XcryVO getById(String id);


    /**
     * 分页查询
     *
     * @param current 当前页
     * @param size 每页显示条数
     * @param xcryVO
     * @return
     */
    Page<XcryVO> page(long current, long size, XcryVO xcryVO);

    /**
     * 本单位巡查人员下拉框
     * @param orgId
     * @return
     */
    List<ComboboxVo> xcryComboBox(String orgId);
}

