package com.kdgcsoft.jt.xzzf.dubbo.xtba.taskManage.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.dubbo.xtba.taskManage.entity.XcqkmxVO;
import com.kdgcsoft.jt.xzzf.dubbo.xtba.taskManage.entity.XczjclGlVO;

import java.util.List;

/**
 * 巡查日志明细服务类
 *
 * @author zd
 * @since 2020-02-17
 */
public interface XcqkmxService {

    /**
     * 新增巡查附件
     *
     * @param xcgvo
     * @return
     */
    boolean insertEntity(XczjclGlVO xcgvo);

    /**
     * 新增信息
     *
     * @param xcqkmxVO
     * @return
     */
    boolean insert(XcqkmxVO xcqkmxVO);

    /**
     * 修改信息
     *
     * @param xcqkmxVO
     * @return
     */
    boolean updateById(XcqkmxVO xcqkmxVO);

    /**
     * 根据ID删除信息
     *
     * @param xcqkmxVO
     * @return
     */
    boolean deleteById(XcqkmxVO xcqkmxVO);

    /**
     * 根据ID获取信息
     *
     * @param id
     * @return
     */
    XcqkmxVO getById(String id);


    /**
     * 巡查情况明细（根据巡查日志id查询）
     *
     * @param xcrzid 巡查日志id
     * @return
     */
    List<XcqkmxVO> xcqkmxByXcrzId(String xcrzid);

    /**
     * 根据巡查日志id查询巡查情况明细
     *
     * @param current
     * @param size
     * @param xcqkmxVO
     * @return
     */
    Page<XcqkmxVO> page(long current, long size, XcqkmxVO xcqkmxVO);

    /**
     * 根据巡查日志id，查询巡查情况明细
     *
     * @param xcrzid
     * @return
     */
    List<XcqkmxVO> searchXcqkmxByXcrzid(String xcrzid);

    /**
     * 根据巡查日志id，查询巡查日志附件
     *
     * @param xcrzid
     * @return
     */
    List<XcqkmxVO> searchXcfjInfoByXcrzid(String xcrzid);
}

