package com.kdgcsoft.jt.xzzf.dubbo.xtba.taskManage.service;

import com.kdgcsoft.jt.xzzf.dubbo.xtba.taskManage.entity.XclxVO;

import java.util.List;

/**
 * 巡查路线服务类
 *
 * @author zd
 * @since 2020-02-17
 */
public interface XclxService {

    /**
     * 新增信息
     *
     * @param xclxVO
     * @return
     */
    boolean insert(XclxVO xclxVO);

    /**
     * 修改信息
     *
     * @param xclxVO
     * @return
     */
    boolean updateById(XclxVO xclxVO);

    /**
     * 根据ID删除信息
     *
     * @param xclxVO
     * @return
     */
    boolean deleteById(XclxVO xclxVO);

    /**
     * 根据ID获取信息
     *
     * @param id
     * @return
     */
    XclxVO getById(String id);

    /**
     * 根据巡查日志id查询巡查路线
     *
     * @param xcrzid 巡查日志id
     * @return
     */
    List<XclxVO> xclxByXcrzId(String xcrzid);

    /**
     * 根据巡查日志id查询巡查路线
     *
     * @param xcrzid 巡查日志id
     * @return
     */
    List<XclxVO> serachXclxByXcrzId(String xcrzid);

    /**
     * 根据巡查日志id，查询巡查路线信息
     *
     * @param xcrzid
     * @return
     */
    List<XclxVO> searchXclxByXcrzid(String xcrzid);
}

