package com.kdgcsoft.jt.xzzf.dubbo.xtba.taskManage.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.common.component.ComboboxVo;
import com.kdgcsoft.jt.xzzf.dubbo.xtba.taskManage.entity.XcjhVO;

import java.text.ParseException;
import java.util.HashMap;
import java.util.List;

/**
 * <p>
 *  服务类
 * </p>
 *
 * @author zd
 * @since 2020-02-11
 */
public interface XcjhService {

    /**
     * 分页查询
     *
     * @param current 当前页
     * @param size 每页显示条数
     * @param xcjhVO
     * @return
     */
    Page<XcjhVO> page(long current, long size, XcjhVO xcjhVO);


    /**
     * 当前日期的计划个数
     * @param jhbh
     * @return
     */
    int countCurrentDate(String jhbh);

    /**
     * 新增巡查日志
     * @param xcjhVO
     */
    void submitXcjh(XcjhVO xcjhVO) throws ParseException;

    /**
     * 批量删除巡查计划
     * @param ids 巡查计划id，多个逗号拼接
     * @param xcjhVO
     * @return
     */
    boolean deleteById(String ids,XcjhVO xcjhVO);

    /**
     *修改或者查看巡查计划
     * @param xcjhid
     * @return
     */
    XcjhVO getById(String xcjhid);

    /**
     * 获取相应的巡查人员姓名贺巡查人员id
     * @param xcjhid
     * @return
     */
    List<XcjhVO> selectXcry(String xcjhid);
}

