package com.kdgcsoft.jt.xzzf.dubbo.xtba.taskManage.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.common.component.ComboboxVo;
import com.kdgcsoft.jt.xzzf.dubbo.xtba.taskManage.entity.JcsxxxVO;

import java.util.List;

/**
 * 检查事项信息接口
 *
 * @author zd
 * @since 2020-02-24
 */
public interface JcsxxxService {

    /**
     * 新增
     *
     * @param jcsxxxVO
     * @return
     */
    boolean insert(JcsxxxVO jcsxxxVO);

    /**
     * 修改
     *
     * @param jcsxxxVO
     * @return
     */
    boolean update(JcsxxxVO jcsxxxVO);

    /**
     * 分页查询
     *
     * @param current  当前页
     * @param size     每页显示条数
     * @param jcsxxxVO
     * @return
     */
    Page<JcsxxxVO> page(long current, long size, JcsxxxVO jcsxxxVO);

    /**
     * 根据id、版本号查询详情
     *
     * @param jcsxxxid 检查事项信息id
     * @param jcsxbbh  检查事项信息版本号
     * @return
     */
    JcsxxxVO getByIdAndBbh(String jcsxxxid, long jcsxbbh);

    /**
     * 根据id、版本号删除
     *
     * @param jcsxxxVO
     * @return
     */
    boolean deleteByIdAndBbh(JcsxxxVO jcsxxxVO);

    /**
     * 是否启用
     *
     * @param jcsxxxVO
     * @return
     */
    boolean enableOrDisable(JcsxxxVO jcsxxxVO);

    /**
     * 根据查询条件获取数据
     *
     * @param jcsxxxVO
     * @return
     */
    List<JcsxxxVO> exportExcelByQuery(JcsxxxVO jcsxxxVO);

    /**
     * 判断有无旧版本
     *
     * @param jcsxxxid id
     * @param jcsxbbh  版本号
     * @return
     */
    Integer versionCount(String jcsxxxid, long jcsxbbh);

    /**
     * 根据id、版本号获取信息
     *
     * @param jcsxxxid id
     * @param jcsxbbh  版本号
     * @return
     */
    JcsxxxVO searchByIdAndBbh(String jcsxxxid, long jcsxbbh);

    /**
     * 当前版本的上个版本号
     *
     * @param jcsxxxid id
     * @param jcsxbbh  版本号
     * @return
     */
    long findOldJcsxbbh(String jcsxxxid, long jcsxbbh);

    /**
     * 最大版本号
     *
     * @param jcsxxxid
     * @return
     */
    long findMaxBbh(String jcsxxxid);

    /*****
     * 查询检查事项下拉框的键值对
     * @param filter 关键字过滤
     * @return
     */
    public List<ComboboxVo> queryEntityCombobox(String filter,String orgId);

    /**
     * 根据检查项目，模糊查询检查事项
     * @param vo
     * @return
     */
    List<JcsxxxVO> searchJcsxByJcxm(JcsxxxVO vo);
}

