package com.kdgcsoft.jt.xzzf.dubbo.xtba.taskManage.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;
import com.kdgcsoft.jt.xzzf.dubbo.xtba.taskManage.entity.JcrwVO;

/****
 * @className JcrwService
 * @author chris
 * @description 检查任务Service接口层接口
 * @version 1.0
 * @date 2020-03-16 10:18
 */
public interface JcrwService {

    /*****
     * 分页查询
     * @param page 分页信息
     * @param entity 实体类
     * @param isPage 是否分页
     * @return
     */
    public Page<JcrwVO> page(Page<JcrwVO> page, JcrwVO entity,SysUser userInfo, boolean isPage);

    /*****
     * 保存检查任务数据
     * @param entity 实体类
     * @param user 当前登录用户
     * @param isCreate 是否创建
     */
    public void saveOrUpdate(JcrwVO entity, SysUser user, boolean isCreate);

    /*****
     * 获取检查任务信息
     * @param id 主键ID
     * @return
     */
    public JcrwVO getEntityInfoById(String id);

    /*****
     * 删除检查任务信息
     * @param ids 主键Id集合
     */
    public void deleteDataByIds(String ids);

    /*****
     * 发布检查任务信息
     * @param ids 主键Id集合
     */
    public void publishDataByIds(String ids);

    /*****
     * 行政检查统计--首页
     * @param jcrwVO
     * @return
     */
    Integer getXzjcCountByOrgId(JcrwVO jcrwVO,String curUserOrgId);

}
