package com.kdgcsoft.jt.xzzf.dubbo.xtba.taskManage.entity;

import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * 巡查日志实体类
 *
 * @author zd
 * @since 2020-02-17
 */
@Data
@TableName("XTBA_J_XCRZ")
public class XcrzVO extends BaseEntity<String> {

    private static final long serialVersionUID = 1L;

    /**
     * 巡查日志id
     */
    @TableId
    private String xcrzid;

    /**
     * app接收参数
     */
    @TableField(exist = false)
    private String formJson;

    /**
     * 天气代码
     */
    private String tqdm;

    /**
     * 巡查日志编号
     */
    private String xcrzbh;

    /**
     * 巡查里程
     */
    private Double xclc;

    /**
     * 巡查车辆
     */
    private String xccl;

    /**
     * 巡查负责人id
     */
    private String xcfzrid;

    /**
     * 巡查负责人
     */
    private String xcfzr;

    /**
     * 当班中队id
     */
    private String dbzdid;

    /**
     * 当班中队
     */
    private String dbzd;

    /**
     * 巡查人员id，多个逗号分隔
     */
    private String xcryid;

    /**
     * 巡查人员，多个逗号分隔
     */
    private String xcry;

    /**
     * 巡查情况
     */
    private String xcqk;

    /**
     * 处理情况
     */
    private String clqk;

    /**
     * 移交事项
     */
    private String yjsx;

    /**
     * 交班人id
     */
    private String jbrid;

    /**
     * 交班人
     */
    private String jbr;

    /**
     * 接班人id
     */
    private String jiebrid;

    /**
     * 接班人
     */
    private String jiebr;

    /**
     * 交班时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date jbsj;

    /**
     * 机构
     */
    private String jg;

    /**
     * 机构id
     */
    private String jgid;

    /**
     * 备注
     */
    private String bz;

    /**
     * 巡查日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JSONField(format = "yyyy-MM-dd")
    private Date xcrq;

    /**
     * 驾驶员id
     */
    private String jsyid;

    /**
     * 驾驶员
     */
    private String jsy;

    /**
     * 巡查计划id
     */
    private String xcjhid;

    /**
     * 日志内容
     */
    private String rznr;

    /***********************  非表中字段   *************************/
    /**
     * 类型（1：个人；2：单位）
     */
    @TableField(exist = false)
    private String leixing;

    /**
     * 巡查路线
     */
    @TableField(exist = false)
    private String xclx;

    /**
     * 巡查日期字符串
     */
    @TableField(exist = false)
    private String xcrqStr;

    /**
     * 巡查日期起
     */
    @TableField(exist = false)
    private String xcrqStart;

    /**
     * 巡查日期止
     */
    @TableField(exist = false)
    private String xcrqEnd;

    /**
     * 巡查计划名称
     */
    @TableField(exist = false)
    private String xcjhmc;


    /**
     * 记录人
     */
    @TableField(exist = false)
    private String jlr;

    /**
     * 排查情况
     */
    @TableField(exist = false)
    private String pcjl;

    /**
     * 情况小结
     */
    @TableField(exist = false)
    private String qkxj;

    /**
     * 计划编号
     */
    @TableField(exist = false)
    private String jhbh;

    @TableField(exist = false)
    private String jhxclx;

    /**
     * 临时id
     */
    @TableField(exist = false)
    private String lsid;

    /**
     * 巡查车里程
     */
    @TableField(exist = false)
    private String xcclc;

    /**
     * 车异常记录
     */
    @TableField(exist = false)
    private String cycjl;

    /**
     * 巡查情况小结
     */
    @TableField(exist = false)
    private String xcqkxj;

    /**
     * 交班时间
     */
    @TableField(exist = false)
    private String jbsjStr;

    @Override
    public String getId() {
        return xcrzid;
    }

    @Override
    public void setId(String id) {
        this.xcrzid = id;
    }


}
