package com.kdgcsoft.jt.xzzf.dubbo.xtba.taskManage.entity;

import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;


/**
 * 巡查情况明细
 *
 * @author zd
 * @since 2020-02-17
 */
@Data
@TableName("XTBA_J_XCQKMX")
public class XcqkmxVO extends BaseEntity<String> {

    private static final long serialVersionUID = 1L;

    /**
     * 巡查情况明细id
     */
    @TableId
    private String xcqkmxid;

    /**
     * app接收参数
     */
    @TableField(exist = false)
    private String formJson;

    /**
     * 巡查日志id
     */
    private String xcrzid;

    /**
     * 身份证件类型代码
     */
    private String sfzjlxdm;

    /**
     * 发现时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date fxsj;

    /**
     * 路线
     */
    private String lx;

    /**
     * 桩号K
     */
    private Double zhk;

    /**
     * 桩号M
     */
    private Double zhm;

    /**
     * 问题描述
     */
    private String wtms;

    /**
     * 巡查问题处置情况代码
     * 01已改正或已清除 02 已向当事人下发（责令改正通知书）99其他
     */
    private String xcwtczqkdm;

    /**
     * 方向
     * 1上行 2下行
     */
    private String fx;

    /**
     * 其它处理情况
     */
    private String qtclqk;

    /*********************** 非表中字段 ***************************/

    /**
     * 附件id（多个逗号拼接）
     */
    @TableField(exist = false)
    private String fjid;

    /**
     * 材料名称
     */
    @TableField(exist = false)
    private String clmc;

    /**
     * 保存路径
     */
    @TableField(exist = false)
    private String bclj;
    /**
     * 保存路径
     */
    @TableField(exist = false)
    private List bcljArr;
    /**
     * 材料名称
     */
    @TableField(exist = false)
    private List clmcArr;


    /**
     * 附件id
     */
    @TableField(exist = false)
    private List fjidArr;

    /**
     * 附件信息json字符串
     */
    @TableField(exist = false)
    private String fjJson;

    /**
     * 单位名称
     */
    @TableField(exist = false)
    private String dwmc;

    /**
     * 单位名称
     */
    @TableField(exist = false)
    private String zh;

    /**
     * 巡查情况
     */
    @TableField(exist = false)
    private String xcqk;

    /**
     * 路线方向
     */
    @TableField(exist = false)
    private String lxfx;

    /**
     * 发现时间
     */
    @TableField(exist = false)
    private String fxsjStr;

    @Override
    public String getId() {
        return xcqkmxid;
    }

    @Override
    public void setId(String id) {
        this.xcqkmxid = id;
    }


}
