package com.kdgcsoft.jt.xzzf.dubbo.xtba.taskManage.entity;

import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * 巡查路线实体类
 *
 * @author zd
 * @since 2020-02-17
 */
@Data
@TableName("XTBA_J_XCLX")
public class XclxVO extends BaseEntity<String> {

    private static final long serialVersionUID = 1L;

    /**
     * 巡查路线id
     */
    @TableId
    private String xclxid;

    /**
     * 巡查日志id
     */
    private String xcrzid;

    /**
     * app接收参数
     */
    @TableField(exist = false)
    private String formJson;

    /**
     * 巡查开始时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date xckssj;
    /**
     * 巡查开始时间
     */
    @TableField(exist = false)
    private String xcksStr;

    /**
     * 巡查结束时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date xcjssj;
    /**
     * 巡查结束时间
     */
    @TableField(exist = false)
    private String xcjsStr;

    /**
     * 路线
     */
    private String lx;

    /**
     * 起点桩号K
     */
    private Long qdzhk;

    /**
     * 起点桩号M
     */
    private Double qdzhm;

    /**
     * 终点桩号K
     */
    private Long zdzhk;

    /**
     * 终点桩号M
     */
    private Double zdzhm;

    /**
     * 巡查时间起始值
     */
    @TableField(exist = false)
    private String xcsjqz;

    /**
     * 巡查路线详情（带起始桩号）
     */
    @TableField(exist = false)
    private String xclxDetails;

    @Override
    public String getId() {
        return xclxid;
    }

    @Override
    public void setId(String id) {
        this.xclxid = id;
    }


}
