package com.kdgcsoft.jt.xzzf.dubbo.xtba.taskManage.entity;

import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;


/**
 * 巡查计划明细实体类
 *
 * @author zd
 * @since 2020-02-11
 */
@Data
@TableName("XTBA_J_XCJHMX")
public class XcjhmxVO extends BaseEntity<String> {

    private static final long serialVersionUID = 1L;

    /**
     * 巡查计划明细id
     */
    @TableId
    private String xcjhmxid;

    /**
     * 巡查日志id
     */
    private String xcrzid;

    /**
     * 巡查计划id
     */
    private String xcjhid;

    /**
     * 日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JSONField(format = "yyyy-MM-dd")
    private Date rq;

    /**
     * 巡查车辆
     */
    private String xccl;

    /**
     * 巡查路线（多条路线逗号分隔）
     */
    private String xclx;

    /**
     * 巡查中队id
     */
    private String xczdid;

    /**
     * 巡查中队
     */
    private String xczd;

    /**
     * 状态（0待反馈,1已反馈）
     */
    private String zt;

    /**
     * 巡查路线名称（多条逗号分隔）
     */
    private String xclxmc;

    /**
     * 巡查人员id（多条逗号分隔）
     */
    private String xcryid;

    /**
     * 巡查人员名称（多条逗号分隔）
     */
    private String xcrymc;

    /**
     * 数据插入时排序
     */
    private Long sort;

    /********************** 非表中字段 **************************/

    @Override
    public String getId() {
        return xcjhmxid;
    }

    @Override
    public void setId(String id) {
        this.xcjhmxid = id;
    }

}
