package com.kdgcsoft.jt.xzzf.dubbo.xtba.taskManage.entity;

import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * 巡查计划
 *
 * @author zd
 * @since 2020-02-11
 */
@Data
@TableName("XTBA_J_XCJH")
public class XcjhVO extends BaseEntity<String> {

    private static final long serialVersionUID = 1L;

    /**
     * 巡查计划id
     */
    @TableId("XCJHID")
    private String xcjhid;

    /**
     * 计划编号
     */
    private String jhbh;

    /**
     * 巡查类别
     */
    private String xclb;

    /**
     * 巡查路线
     */
    private String xclx;

    /**
     * 巡查路线数组
     */
    @TableField(exist = false)
    private String[] xclxs;

    /**
     * 巡查人员
     */
    private String xcry;

    /**
     * 负责人
     */
    private String fzr;

    /**
     * 负责人id
     */
    private String fzrid;

    /**
     * 负责人执法证号
     */
    private String fzrzfzh;


    /**
     * 计划内容
     */
    private String jhnr;

    /**
     * 备注
     */
    private String bz;

    /**
     * 机构
     */
    private String jg;

    /**
     * 机构id
     */
    private String jgid;

    /**
     * 制定人id
     */
    private String zdrid;

    /**
     * 制定人
     */
    private String zdr;

    /**
     * 计划名称
     */
    private String jhmc;

    /**
     * 任务状态
     */
    private String zt;

    /***************** 查询字段 *******************/

    /**
     * 开始时间字符串
     */
    @TableField(exist = false)
    public String kssjStr;

    /**
     * 开始时间起
     */
    @TableField(exist = false)
    public String kssjStart;

    /**
     * 开始时间止
     */
    @TableField(exist = false)
    public String kssjEnd;

    /**
     * 结束时间字符串
     */
    @TableField(exist = false)
    public String jssjStr;

    /**
     * 结束时间起
     */
    @TableField(exist = false)
    public String jssjStart;

    /**
     * 结束时间止
     */
    @TableField(exist = false)
    public String jssjEnd;

    /**
     * 当前时间
     */
    @TableField(exist = false)
    public String dateTime;

    /**
     * 巡查计划明细json数据
     */
    @TableField(exist = false)
    private String xcjhmxJson;

    /**
     * 起止日期
     */
    @TableField(exist = false)
    private String[] qzrq;

    /**
     * 开始时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JSONField(format = "yyyy-MM-dd")
    private Date kssj;

    /**
     * 结束时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JSONField(format = "yyyy-MM-dd")
    private Date jssj;

    /**
     * 巡查人员id
     */
    @TableField(exist = false)
    public String xcryid;

    /**
     * 巡查人员执法证号
     */
    @TableField(exist = false)
    public String xcryzfzh;

    /**
     * 用户名
     */
    @TableField(exist = false)
    public String userCode;

    /**
     *
     */
    @TableField(exist = false)
    public String zfryid;

    /**
     * 巡查人员
     */
    @TableField(exist = false)
    public String zfryids;

    /**
     * 计划名称
     */
    @TableField(exist = false)
    public String rwbt;

    /**
     * 检查人员姓名
     */
    @TableField(exist = false)
    public String jcry;

    /**
     *
     */
    @TableField(exist = false)
    public String zfry;

    /**
     * 任务类型
     */
    @TableField(exist = false)
    public String rwlx;

    /**
     *临时id
     */
    @TableField(exist = false)
    public String lsid;

    @Override
    public String getId() {
        return xcjhid;
    }

    @Override
    public void setId(String id) {
        this.xcjhid = id;
    }

}
