package com.kdgcsoft.jt.xzzf.dubbo.xtba.taskManage.entity;

import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;

/**
 * 巡查日志实体类
 *
 * @author zd
 * @since 2020-02-17
 */
@Data
@TableName("XTBA_J_XCJBJL")
public class XcjbjlVO implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 巡查交接记录ID
     */
    @TableId
    private String xcjjjlid;

    /**
     * 巡查日志id
     */
    private String xcrzid;

    /**
     * 巡查车里程
     */
    private String xcclc;

    /**
     * 移交事项
     */
    private String yjsx;

    /**
     * 车异常记录
     */
    private String cycjl;

    /**
     * 巡查情况小结
     */
    private String xcqkxj;

    /**
     * 交班负责人
     */
    private String jbfzr;

    /**
     * 接班负责人
     */
    private String jbr;

    /**
     * 交班时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JSONField(format = "yyyy-MM-dd")
    private Date jbsj;

    /**
     * 负责任
     */
    @TableField(exist = false)
    private String xcfzr;

    /**
     * 驾驶员
     */
    @TableField(exist = false)
    private String jsy;

    /**
     * 天气
     */
    @TableField(exist = false)
    private String tqdm;

    /**
     * 巡查车辆
     */
    @TableField(exist = false)
    private String xccl;

    /**
     * 记录人
     */
    @TableField(exist = false)
    private String jlr;

}
