package com.kdgcsoft.jt.xzzf.dubbo.xtba.taskManage.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;

/**
 * 检查事项信息
 *
 * @author zd
 * @since 2020-02-24
 */
@Data
@TableName("XTBA_J_JCSXXX")
public class JcsxxxVO extends BaseEntity<String> {

    private static final long serialVersionUID = 1L;

    /**
     * 检查事项信息id
     */
    @TableId("JCSXXXID")
    private String jcsxxxid;

    /**
     * 检查事项版本号
     */
    private Long jcsxbbh;

    /**
     * 检查事项类别代码
     */
    private String jcsxlbdm;

    /**
     * 检查项目
     */
    private String jcxm;

    /**
     * 检查依据
     */
    private String jcyj;

    /**
     * 检查内容
     */
    private String jcnr;

    /**
     * 检查对象
     */
    private String jcdx;

    /**
     * 检查方式，多个逗号分隔
     */
    private String jcfs;

    /**
     * 检查频次（次/年）
     */
    private Long jcpc;

    /**
     * 抽查比例，%
     */
    private Double ccbl;

    /**
     * 备注
     */
    private String bz;

    /**
     * 机构
     */
    private String jg;

    /**
     * 机构id
     */
    private String jgid;

    /**
     * 是否启用，0 禁用，1 启用
     */
    private String sfqy;

    /**********************非表中字段************************/

    /**
     * 是否启用数组
     */
    @TableField(exist = false)
    private String[] sfqyArray;

    /**
     * 版本更新时间
     */
    @TableField(exist = false)
    private String bbgxsjStr;

    /**
     * 版本更新时间起
     */
    @TableField(exist = false)
    private String bbgxsjStart;

    /**
     * 版本更新时间止
     */
    @TableField(exist = false)
    private String bbgxsjEnd;

    /**
     * 检查频次字符串
     */
    @TableField(exist = false)
    private String jcpcStr;

    /**
     * 抽查比例字符串
     */
    @TableField(exist = false)
    private String ccblStr;

    /**
     * 检查事项版本号字符串
     */
    @TableField(exist = false)
    private String jcsxbbhStr;

    /**
     * 是否更新版本
     */
    @TableField(exist = false)
    private String sfgxbb;

    @Override
    public String getId() {
        return jcsxxxid;
    }

    @Override
    public void setId(String id) {
        this.jcsxxxid = id;
    }


}
