package com.kdgcsoft.jt.xzzf.dubbo.xtba.taskManage.entity;

import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;

/****
 * @className RwdbVO
 * @author chris
 * @description 任务代办实体类
 * @version 1.0
 * @date 2020-03-16 09:50
 */
@Data
@TableName("XTBA_J_JCRW")
public class JcrwVO extends BaseEntity<String> {
    private static final long serialVersionUID = 1L;

    /*****
     * 检查任务Id
     */
    @TableId("JCRWID")
    private String jcrwid;

    /******
     * 检查事项信息id
     */
    private String jcsxxxid;

    /******
     * 检查事项版本号
     */
    private Long jcsxbbh;

    /******
     * 任务编号
     */
    private String rwbh;

    /******
     * 任务标题
     */
    private String rwbt;

    /******
     * 检查项目
     */
    private String jcxm;

    /******
     * 检查依据
     */
    private String jcyj;

    /******
     * 检查内容
     */
    private String jcnr;

    /**
     * 任务状态
     */
    private String rwzt;

    /*****
     * 开始时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JSONField(format = "yyyy-MM-dd")
    private Date kssj;

    /*****
     * 结束时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JSONField(format = "yyyy-MM-dd")
    private Date jssj;

    /******
     * 任务状态数组
     */
    private String[] rwzts;

    /******
     * 任务类型
     */
    private String rwlx;

    /******
     * 任务类型数组
     */
    @TableField(exist = false)
    private String[] rwlxs;

    /******
     * 巡查任务
     */
    @TableField(exist = false)
    private String xcrwlx;

    /******
     * 机构ID
     */
    private String jgid;

    /******
     * 机构
     */
    private String jg;

    /**********************非表中字段************************/

    /******
     * 任务状态对应的文本值
     */
    @TableField(exist = false)
    private String rwztText;

    /******
     * 检查对象
     * @return
     */
    @TableField(exist = false)
    private String jcdxDetail;

    //首页日期
    @TableField(exist = false)
    private String rq;

    /******
     * 开始时间Str
     * @return
     */
    @TableField(exist = false)
    private String kssjStr;

    @TableField(exist = false)
    private String[] kssjArr;

    @TableField(exist = false)
    private String kssjSta;

    @TableField(exist = false)
    private String kssjEnd;

    /******
     * 结束时间Str
     * @return
     */
    @TableField(exist = false)
    private String jssjStr;

    @TableField(exist = false)
    private String[] jssjArr;

    @TableField(exist = false)
    private String jssjSta;

    @TableField(exist = false)
    private String jssjEnd;

    /******
     * 检查人员
     * @return
     */
    @TableField(exist = false)
    private String jcry;

    /******
     * 检查人员id
     * @return
     */
    @TableField(exist = false)
    private String jcryid;

    //检查任务管理(新增0,修改1)
    @TableField(exist = false)
    private String flager;

    //检查方式
    @TableField(exist = false)
    private String jcfser;

    /******
     * 检查记录id
     * @return
     */
    @TableField(exist = false)
    private String jcjlid;

    /**
     * guid
     */
    @TableField(exist = false)
    private String guid;

    /**
     * jcrwmxid
     */
    @TableField(exist = false)
    private String jcrwmxid;

    @TableField(exist = false)
    private String[] rwlxsz;

    @TableField(exist = false)
    private String[] rwztsz;

    @TableField(exist = false)
    private String fzr;

    @TableField(exist = false)
    private String xclx;

    @TableField(exist = false)
    private Jcjl jcjl;

    /**
     * 本单位:0
     * 本单位和下属单位:1
     */
    @TableField(exist = false)
    private String dwbz;

    /**
     * 用户姓名
     */
    @TableField(exist = false)
    private String yhxm;

    /**
     * 临时id
     */
    @TableField(exist = false)
    private String lsid;

    @Override
    public String getId() {
        return jcrwid;
    }

    @Override
    public void setId(String id) {
        this.jcrwid = id;
    }
}
