package com.kdgcsoft.jt.xzzf.dubbo.xtba.laws.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.dubbo.xtba.laws.entity.ZyclqVO;

import java.util.List;

/**
 * <p>
 *  服务类
 * </p>
 *
 * @author zd
 * @since 2019-12-27
 */
public interface ZyclqService {

    /**
     * 新增信息
     *
     * @param zyclqVO
     * @return
     */
    boolean insert(ZyclqVO zyclqVO);

    /**
     * 修改信息
     *
     * @param zyclqVO
     * @return
     */
    boolean updateById(ZyclqVO zyclqVO);

    /**
     * 根据id删除自由裁量权
     * @param zyclqid 自由裁量权id
     * @return
     */
    boolean deleteById(String zyclqid);

    /**
     * 根据职权项目id查询自由裁量权
     * @param zyclqid 自由裁量权id
     * @return
     */
    ZyclqVO getById(String zyclqid);


    /**
     * 分页查询
     *
     * @param current 当前页
     * @param size 每页显示条数
     * @param zyclqVO
     * @return
     */
    Page<ZyclqVO> page(long current, long size, ZyclqVO zyclqVO);

    /**
     * 通过职权项目id查询自由裁量权
     * @param zqxmid
     * @param zqxmbbh
     * @return
     */
    List<ZyclqVO> searchZyclqForZqxm(String zqxmid, long zqxmbbh);
}

