package com.kdgcsoft.jt.xzzf.dubbo.xtba.laws.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.common.component.TreeDataVo;
import com.kdgcsoft.jt.xzzf.dubbo.xtba.laws.entity.ZqxmVO;
import org.apache.ibatis.annotations.Param;

import java.util.HashMap;
import java.util.List;


/**
 * <p>
 * 服务类
 * </p>
 *
 * @author zd
 * @since 2019-12-27
 */
public interface ZqxmService {

    /**
     * 根据ID获取信息
     *
     * @param id
     * @return
     */
    ZqxmVO getById(String id);


    /**
     * 分页查询
     *
     * @param current 当前页
     * @param size    每页显示条数
     * @param zqxmVO
     * @return
     */
    Page<ZqxmVO> page(long current, long size, ZqxmVO zqxmVO);

    /**
     * 查询职权项目excel导出数据
     *
     * @param zqxmId
     * @return
     */
    List<ZqxmVO> selectZqxmForExcel(ZqxmVO zqxmId);

    /**
     * 修改职权项目
     *
     * @param map
     */
    Boolean updateZqxm(HashMap map);

    /***
     * 职权项目启用/禁用
     * @param zqxmVO
     * @param sfqy 是否启用
     * @return
     */
    Boolean enableOrDisableZqxm(ZqxmVO zqxmVO, String sfqy);

    /**
     * 新增职权项目
     *
     * @param map
     */
    Boolean addZqxm(HashMap map);

    /**
     * 删除职权项目
     *
     * @param list
     * @return
     */
    Boolean deleteZqxm(List<ZqxmVO> list);

    /**
     * 根据职权id查询版本号和执法门类
     *
     * @param zqxmId
     * @return
     */
    ZqxmVO getZqxx(String zqxmId);

    /**
     * 通过id和版本号查询职权项目信息(包含执法依据、自由裁量权)
     *
     * @param zqxmId
     * @param zqxmbbh
     * @return
     */
    ZqxmVO searchZqxmByIdAndBBH(String zqxmId, long zqxmbbh);

    /**
     * 职权版本个数
     *
     * @param zqxmId
     * @param zqxmbbh
     * @return
     */
    Integer versionCount(String zqxmId, long zqxmbbh);

    /**
     * 上个版本号
     *
     * @param zqxmId
     * @param zqxmbbh
     * @return
     */
    long findOldZqxmBBhById(String zqxmId, long zqxmbbh);

    /**
     * 新增职权更新版本
     *
     * @param map
     * @return
     */
    Boolean updateZqxmVersion(HashMap map);

    /**
     * 通过id和版本号查询职权项目
     *
     * @param zqxmid
     * @param zqxmbbh
     * @return
     */
    ZqxmVO searchOnlyZqxmByIdAndBBH(String zqxmid, long zqxmbbh);

    /**
     * 获取勾选的职权信息
     *
     * @param list
     * @return
     */
    List<ZqxmVO> searchZqxmForExcel(List<ZqxmVO> list);


    /**
     * 根据zfyjid查询所有使用该条执法依据的职权项目
     *
     * @param zqxmVO 查询条件
     * @return Page<ZqxmVO> 职权项目列表信息
     */
    Page<ZqxmVO> findZqxmByZfyj(long current, long size, ZqxmVO zqxmVO);

    /**
     * 查询最新版本职权项目信息
     *
     * @param zqxmVO 职权项目查询条件
     * @return zqxmVO 职权项目信息
     */
    ZqxmVO findLatestVesion(ZqxmVO zqxmVO);

    String findZfyjlxByIdAndBbh(ZqxmVO zqxmVO);

    /**
     * 违法事项分页查询
     *
     * @param current
     * @param size
     * @param zqxmVO
     * @return
     */
    Page<ZqxmVO> wfsxPage(long current, long size, ZqxmVO zqxmVO);

    /**
     * 根据职权项目id和版本号，查询轻微免罚相关信息
     *
     * @param zqxmId
     * @param zqxmbbh
     * @return
     */
    ZqxmVO searchQwmfInfoByZqxmIdAndBbh(String zqxmId, String zqxmbbh);

    /**
     * 轻微免罚清单分页查询
     *
     * @param current
     * @param size
     * @param zqxmVO
     * @return
     */
    Page<ZqxmVO> searchQwmfqdPage(long current, long size, ZqxmVO zqxmVO);

    /**
     * 职权项目树
     *
     * @param zqxmVO
     * @return
     */
    List<TreeDataVo> zqxmTree(ZqxmVO zqxmVO);

    /**
     * 承诺轻罚清单分页查询
     *
     * @param current
     * @param size
     * @param zqxmVO
     * @return
     */
    Page<ZqxmVO> searchCnqfqdPage(long current, long size, ZqxmVO zqxmVO);
}

