package com.kdgcsoft.jt.xzzf.dubbo.xtba.laws.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.dubbo.xtba.caseHandle.entity.AjxxVO;
import com.kdgcsoft.jt.xzzf.dubbo.xtba.caseHandle.service.AjxxService;
import com.kdgcsoft.jt.xzzf.dubbo.xtba.laws.entity.LegalBasisVo;
import com.kdgcsoft.jt.xzzf.dubbo.xtba.laws.entity.ZqxmVO;

import java.util.HashMap;
import java.util.List;

/**
 * <p>
 *  服务类
 * </p>
 *
 * @author linian
 * @since 2019-12-27
 */
public interface LegalBasisService {

    /**
     * 分页查询
     *
     * @param current 当前页
     * @param size 每页显示条数
     * @return 执法依据信息
     */
    Page<LegalBasisVo> searchLegalBasisPage(long current, long size, LegalBasisVo legalBasisVo);

    /**
     * 职权项目与执法依据关系分页查询
     * @param current 当前页
     * @param size 每页显示条数
     */
    Page<LegalBasisVo> searchZqxmZfyjPage(long current, long size);


    /**
     * 根据法律法规名称 查找对应的 法律法规ID
     * @param legalBasisVo 执法依据VO
     * @return String
     */
    String findLawId(LegalBasisVo legalBasisVo);

    /**
     * 判断新增的执法依据信息是否已存在相同的数据
     * @param legalBasisVo
     * @return 执法依据id
     */
    String isExist(LegalBasisVo legalBasisVo);

    /**
     * 添加执法依据信息
     * @param legalBasisVo 执法依据VO
     * @return int
     */
    int insertLegalBasisInfo(LegalBasisVo legalBasisVo);

    /**
     * 根据zfyjId 获取对应的执法依据信息
     * @param zfyjId 执法依据ID
     * @return LegalBasisVo 执法依据信息
     */
    LegalBasisVo getLegalBasisInfoById(String zfyjId);

    /**
     * 修改执法依据信息
     * @param legalBasisVo 执法依据VO
     * @return int
     */
    int updateLegalBasisiInfo(LegalBasisVo legalBasisVo);

    /**
     * 删除执法依据信息  将DELETE_FLAG 改为01 表示删除  00 表示未删除
     * @param legalBasisVo 执法依据VO
     * @return int
     */
    int deleteLegalBasis(LegalBasisVo legalBasisVo);

    /**
     * 立案/处罚依据查询
     * @param zqxmVO 职权项目VO
     * @return List<LegalBasisVo>
     */
    List<LegalBasisVo> searchZFYJForZQXMList(ZqxmVO zqxmVO);

    /**
     * 查询是否存在此条法律法规名称
     * @param flfgmc 法律法规名称
     * @return List<String>
     */
    List<String> findFlfgAll(String flfgmc);

    /**
     * 根据案件信息id，查询当前案件立案依据和处罚依据
     * @param ajxxVO
     * @return
     */
    HashMap<String, Object> searchLayjAndCfyj(AjxxVO ajxxVO);
}

