package com.kdgcsoft.jt.xzzf.dubbo.xtba.laws.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.dubbo.xtba.laws.entity.FxqdVO;

import java.util.List;

public interface FxqdService {

    /**
     * 新增信息
     * @param fxqdVO
     * @return
     */
    boolean saveFxqd(FxqdVO fxqdVO);

    /**
     * 分页查询
     * @param current 当前页
     * @param size 每页显示条数
     * @param fxqdVO
     * @return
     */
    Page<FxqdVO> page(long current, long size, FxqdVO fxqdVO);

    /**
     * 通过id删除风险清单信息
     * @param fxqdid
     * @return
     */
    boolean deleteFxqd(String fxqdid);

    /**
     * 通过id获取风险清单信息
     * @param fxqdid
     * @return
     */
    FxqdVO getRiskListById(String fxqdid);

    /**
     * 修改信息
     * @param fxqdVO
     * @return
     */
    boolean updateFxqd(FxqdVO fxqdVO);

    /**
     * 根据算法编码获取预警清单
     * @param code
     * @return
     */
    List<FxqdVO> getByCode(String code);
}

