package com.kdgcsoft.jt.xzzf.dubbo.xtba.laws.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.common.rest.Result;
import com.kdgcsoft.jt.xzzf.dubbo.xtba.common.entity.FjbVO;
import com.kdgcsoft.jt.xzzf.dubbo.xtba.laws.entity.FlfgVO;
import java.util.List;

public interface FlfgService {

    /**
     * 修改信息
     * @param xtbaJFlfg
     * @return
     */
    boolean updateFlfgById(FlfgVO xtbaJFlfg);

    /**
     * 根据ID删除信息
     * @param id
     * @return
     */
    boolean deleteById(String id);

    /**
     * 根据ID获取信息
     * @param id
     * @return
     */
    FlfgVO getFlfgById(String id);

    /**
     * 自定义分页查询
     * @param current
     * @param size
     * @param xtbaJFlfg
     * @return
     */
    Page<FlfgVO> searchLawPage(long current, long size, FlfgVO xtbaJFlfg);

    /**
     * 通过名称查找
     * @param flfgmc
     * @return
     */
    List<FlfgVO> getFlfgByName(String flfgmc);

    /**
     * 根据法律法规名称查找法律法规信息
     * @param flfgVO
     * @return
     */
    FlfgVO searcharFlfgInfo(FlfgVO flfgVO);

    /**
     * 根据关键字模糊查询法律法规名称
     * @param flfgmc
     * @return
     */
    List<FlfgVO> searchFlfgMc(String flfgmc);

    /**
     * 保存法律法规
     * @param xtbaJFlfg
     * @return
     */
    boolean insertFlfgById(FlfgVO xtbaJFlfg);

    /**
     * 判断法律法规是否重复
     * @param flfgmc
     * @return
     */
    List<FlfgVO> judge(String flfgmc);

    /**
     * 通过法律法规id获取附件信息
     * @param flfgid
     * @return
     */
    List<FjbVO> getFjLj(String flfgid);

    /**
     * 假删附件信息
     * @param fjbVO
     */
    Boolean deleteFjbById(FjbVO fjbVO);

    /**
     * 判断有无附件表
     * @param flfgid
     * @return
     */
    List<FjbVO>  judgeHave(String flfgid);

    Result getActsByFlowCode(String flowCode);
}

