package com.kdgcsoft.jt.xzzf.dubbo.xtba.laws.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;
import com.kdgcsoft.jt.xzzf.dubbo.xtba.laws.entity.DwzqVO;
import com.kdgcsoft.jt.xzzf.dubbo.xtba.laws.entity.PzzqVO;
import com.kdgcsoft.jt.xzzf.dubbo.xtba.laws.entity.ZqxmVO;

import java.util.List;
import java.util.Map;

/**
 * <p>
 * 服务类
 * </p>
 *
 * @author zd
 * @since 2019-12-27
 * 单位职权接口信息
 */
public interface DwzqService {


    /**
     * 获得该单位下的职权
     *
     * @param page
     * @param pzzqVO
     * @return
     */
    Page selectYx(Page page, PzzqVO pzzqVO);

    /**
     * 获得该单位下的 可选职权
     *
     * @param page
     * @param pzzqVO
     * @return
     */
    Page selectKXZQ(Page page, PzzqVO pzzqVO);

    /**
     * 往该单位下新增职权 或更新
     *
     * @param userInfo
     * @param list
     * @param  z
     */
    void insertDwZq(SysUser userInfo, List<PzzqVO> list,ZqxmVO z) throws Exception;

    /**
     * 假删该单位下的职权
     *
     * @param map
     */
    void deleteDwZq(Map<String, Object> map);

    /**
     * 模糊查询职权项目名称
     *
     * @param pzzqVO
     * @return
     */
    List<PzzqVO> searchzqxmmc(PzzqVO pzzqVO);

    /**
     * 获取带单位下的所有职权
     *
     * @param userInfo 当前用户信息
     * @return
     */
    List<DwzqVO> getAllDwZq(SysUser userInfo);

    /**
     * 根据条件查询出到单位下要导出职权的详细信息
     *
     * @param pzzqVO
     * @return
     */
    List<ZqxmVO> selectZqNr(PzzqVO pzzqVO);

    /**
     * 查询单位可选职权 返回List
     *
     * @param pzzqVO
     * @return
     */
    List<PzzqVO> selectAllKxzq(PzzqVO pzzqVO);

    /**
     * 得到职权版本号
     *
     * @param zqxmVO
     * @return
     */
    List<ZqxmVO> selectZqBbh(ZqxmVO zqxmVO);

    /**
     * 查询单位职权条数
     * @return
     * @param orgId
     */
    Integer dwzqCount(String orgId);
}

