package com.kdgcsoft.jt.xzzf.dubbo.xtba.laws.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author zd
 * @since 2019-12-27
 */
@Data
@TableName("XTBA_J_ZQXM")
public class ZqxmVO extends BaseEntity<String> {

    private static final long serialVersionUID = 1L;

    /**
     * 主键id
     */
    @TableId("ZQXMID")
    private String zqxmId;

    /**
     * 职权项目版本号
     */
    private Long zqxmbbh;

    /**
     * 权力类型代码
     */
    private String qllxdm;

    /**
     * 执法门类代码
     */
    private String zfmldm;

    /**
     * 执法门类代码(编码值)
     */
    @TableField(exist = false)
    private String zfmlCode;

    /**
     * 行业
     */
    private String hy;

    /**
     * 行业(编码值)
     */
    @TableField(exist = false)
    private String hyCode;

    /**
     * 职权项目名称
     */
    private String zqxmmc;

    /**
     * 时限
     */
    private Long sx;

    /**
     * 责任事项
     */
    private String zrsx;

    /**
     * 追责情形
     */
    private String zzqx;

    /**
     * 制定机构id
     */
    private String zdjgid;

    /**
     * 制定机构
     */
    private String zdjg;

    /**
     * 0 禁用，1 启用
     */
    private String sfqy;

    /**
     * 启用日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date qyrq;

    /**
     * 职权编号
     */
    private String zqbh;

    /**
     * 职权来源
     */
    private String zqlydm;

    /**
     * 使用级别（省）
     */
    private String sheng;

    /**
     * 使用级别（市）
     */
    private String shi;

    /**
     * 使用级别（县）
     */
    private String xian;

    /**
     * 支持轻微免罚
     */
    private String zcqwmf;

    /**
     * 职权来源区域
     */
    private String zqlyqy;

    /**
     * 轻微免罚类型
     */
    private String qwmflx;

    /**
     * 支持承诺轻罚（1：支持，0：不支持）
     */
    private String zccnqf;

    /**
     * 使用级别（省市县三个级别,分别对应1，2，3）
     */
    @TableField(exist = false)
    private String[] syjb;
    /****************************查询*****************************/
    /**
     * 更新日期字符串
     */
    @TableField(exist = false)
    private String updateTimeStr;
    /**
     * 环节名称
     */
    @TableField(exist = false)
    private String hjmc;
    /**
     * 更新日期数组
     */
    @TableField(exist = false)
    private String[] updateDate;
    /**
     * 更新日期起
     */
    @TableField(exist = false)
    private String updateDateStart;

    /**
     * 更新日期止
     */
    @TableField(exist = false)
    private String updateDateEnd;

    /**
     * 启用日期字符串
     */
    @TableField(exist = false)
    private String qyrqStr;
    /**
     * 启用日期数组
     */
    @TableField(exist = false)
    private String[] qyrqDate;

    /**
     * 启用日期起
     */
    @TableField(exist = false)
    private String qyrqStart;

    /**
     * 启用日期止
     */
    @TableField(exist = false)
    private String qyrqEnd;

    /**
     * 职权项目id与版本
     */
    @TableField(exist = false)
    private String zqxmidbb;

    /**
     * 是否启用数组
     */
    @TableField(exist = false)
    private String[] sfqyArray;

    /**
     * 自由裁量权
     */
    @TableField(exist = false)
    private String cddjdm;
    @TableField(exist = false)
    private String cdnr;
    @TableField(exist = false)
    private String lhbz;
    @TableField(exist = false)
    private String ghbz;
    @TableField(exist = false)
    private String ghje;

    /**
     * 执法依据
     */
    @TableField(exist = false)
    private String t;
    @TableField(exist = false)
    private String k;
    @TableField(exist = false)
    private String x;
    @TableField(exist = false)
    private String m;
    /**
     * 内容
     */
    @TableField(exist = false)
    private String nr;

    /**
     * 执法依据类型
     */
    @TableField(exist = false)
    private String zfyjlxdm;
    @TableField(exist = false)
    private String zqxmzfyjId;

    /**
     * 是否更新版本
     */
    @TableField(exist = false)
    private String sfgxbb;

    /**
     * 执法依据json
     */
    @TableField(exist = false)
    private String zfyjJson;
    /**
     * 自由裁量权json
     */
    @TableField(exist = false)
    private String zyclqJson;
    /**
     * 职权项目json
     */
    @TableField(exist = false)
    private String zqxmJson;

    /**
     * 该职权处罚依据
     */
    @TableField(exist = false)
    private String cfyj;
    /**
     * 该职权立案依据
     */
    @TableField(exist = false)
    private String layj;
    /**
     * 自由裁量权表格数据
     */
    @TableField(exist = false)
    private List<ZyclqVO> zyclqList;

    /**
     * jg
     */
    @TableField(exist = false)
    private String jg;

    /**
     * 案件数
     */
    @TableField(exist = false)
    private Integer ajs;

    /**
     * 职权级别
     */
    @TableField(exist = false)
    private String zqjb;

    /**
     * 执法依据id
     */
    @TableField(exist = false)
    private String zfyjid;

    /**
     * 用户id
     */
    @TableField(exist = false)
    private String userId;

    /**
     * 用户职权项目使用数
     */
    @TableField(exist = false)
    private Long useCount;

    /**
     * 用户信息
     */
    @TableField(exist = false)
    private SysUser sysUser;

    /**
     * 行政区划id
     */
    @TableField(exist = false)
    private String xzqhid;

    /**
     * 子项编码
     */
    @TableField(exist = false)
    private String zxbm;

    /**
     * 法律法规名称
     */
    @TableField(exist = false)
    private String flfgmc;

    @Override
    public String getId() {
        return zqxmId;
    }

    @Override
    public void setId(String id) {
        this.zqxmId = id;
    }


}
