package com.kdgcsoft.jt.xzzf.dubbo.xtba.laws.entity;

import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * <p>
 * 
 * </p>
 *
 * @author linian
 * @since 2019-12-27
 */
@Data
@TableName("XTBA_J_ZFYJ")
public class LegalBasisVo extends BaseEntity<String> {

    private static final long serialVersionUID = 1L;

    /**
     * 执法依据ID 主键
     */
    @TableId
    private String zfyjid;

    /**
     * 法律法规ID
     */
    private String flfgid;

    /**
     * 条
     */
    private String t;

    /**
     * 款
     */
    private String k;

    /**
     * 项
     */
    private String x;

    /**
     * 目
     */
    private String m;

    /**
     * 内容
     */
    private String nr;

    /**
     * 法律法规名称
     */
    private String flfgmc;

    /**
     * 时效性
     */
    private String sxx;


    /**
     * 法律法规类别代码
     */
    private String flfglbdm;

    /**
     * 制定机关
     */
    private String dzjg;

    /**
     * 发布机关
     */
    private String fbjg;

    /**
     * 发布日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JSONField(format = "yyyy-MM-dd")
    private Date fbrq;

    /**
     * 实施日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JSONField(format = "yyyy-MM-dd")
    private Date ssrq;

    /**
     * 更新时间
     */
    @TableField(exist = false)
    private String updateTimeStr;

    /**
     * 发布日期
     */
    @TableField(exist = false)
    private String fbrqStr;

    /**
     * 发布文号
     */
    @TableField(exist = false)
    private String fbwh;

    /**
     * 执法依据类型
     */
    @TableField(exist = false)
    private String zfyjlxdm;

    /**
     * 执法依据类型字符串
     */
    @TableField(exist = false)
    private String zfyjlxdmStr;

    /**
     * 法律时效性  接受前端数据
     */
    @TableField(exist = false)
    private String[] lawSxx;

    /**
     * 发布日期开始
     */
    @TableField(exist = false)
    private String fbrqks;

    /**
     * 发布日期结束
     */
    @TableField(exist = false)
    private String fbrqjs;

    /**
     * 更新日期开始
     */
    @TableField(exist = false)
    private String updateTimeks;

    /**
     * 更新日期结束
     */
    @TableField(exist = false)
    private String updateTimejs;

    /**
     * 职权项目名称
     */
    @TableField(exist = false)
    private String zqxmmc;

    @Override
    public String getId() {
        return zfyjid;
    }

    @Override
    public void setId(String id) {
        this.zfyjid = id;
    }

}
