package com.kdgcsoft.jt.xzzf.dubbo.xtba.informationQuery.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.dubbo.xtba.informationQuery.entity.CyhgzsVo;
import com.kdgcsoft.jt.xzzf.dubbo.xtba.informationQuery.entity.CysrzsVo;
import com.kdgcsoft.jt.xzzf.dubbo.xtba.informationQuery.entity.CyxxVo;

/**
 * <p>
 *  服务类
 * </p>
 *
 * @author linian
 * @since 2020-02-17
 */
public interface CyxxService {

    /**
     * 分页查询
     *
     * @param current 当前页
     * @param size 每页显示条数
     * @param cysrzsVo 查询条件
     * @return 船员适任证书信息
     */
    Page<CysrzsVo> searchCyxxPage(long current, long size, CysrzsVo cysrzsVo);

    /**
     * 查询船员详细信息  船员查询-船员信息页面调用
     * @param sfzhm 身份证号码
     * @return CyxxResultVo船员详细信息
     */
    CyxxVo findCyjcxxInfo(String sfzhm);

    /**
     * 根据身份证号码查询船员适任证书
     * @param sfzhm 身份证号码
     * @return cysrzsVo 船员适任证书信息
     */
    CysrzsVo findCysrzsInfo(String sfzhm);

    /**
     * 根据身份证号码查询船员合格证书信息
     * @param sfzhm 身份证号码
     * @return cyhgzsVo 船员合格证书信息
     */
    CyhgzsVo findCyhgzsInfo(String sfzhm);

}

