package com.kdgcsoft.jt.xzzf.dubbo.xtba.informationQuery.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.dubbo.xtba.caseHandle.entity.AjxxVO;
import com.kdgcsoft.jt.xzzf.dubbo.xtba.informationQuery.entity.CbxxVo;

import java.util.List;

/**
 * <p>
 *  服务类
 * </p>
 *
 * @author linian
 * @since 2020-02-23
 */
public interface CbxxService {

    /**
     * 分页查询船舶信息  船舶查询页面
     * @param current 当前页
     * @param size 每页查询条数
     * @param cbxxVo 查询条件
     * @return 船舶信息
     */
    Page<CbxxVo> searchCbxxPage(long current, long size, CbxxVo cbxxVo);

    /**
     * 查询船舶明细信息 船舶查询页面-船舶明细页面-船舶基本信息
     * @param cbxxid 船舶信息id
     * @return CbxxResultVo 船舶明细信息
     */
    CbxxVo findCbjbInfo(String cbxxid);

    /**
     * 查询船舶明细信息 船舶查询页面-船舶明细页面-船舶行政处罚信息
     * @param cbsbh 船舶识别号
     * @return CbxxResultVo 船舶明细信息
     */
    List<AjxxVO> findCbcfInfo(String cbsbh);

    /**
     * 根据船舶识别号获取船舶信息
     * @param cbsbh 船舶识别号
     * @return
     */
    List<CbxxVo> searchInfoByCbsbh(String cbsbh);
}

