package com.kdgcsoft.jt.xzzf.dubbo.xtba.informationQuery.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * <p>
 * 
 * </p>
 *
 * @author 黄宇
 * @since 2020-02-17
 */
@Data
@TableName("XTBA_J_YHXX")
public class YhXxVO extends BaseEntity<String> {

    private static final long serialVersionUID = 1L;

    /**
     * 业户信息id
     */
    @TableId(value = "YHXXID")
    private String yhxxid;

    /**
     * 信誉等级代码
     */
    private String xydjdm;

    /**
     * 业户状态代码
     */
    private String yhztdm;
    /**
     * 业户状态代码 用于接受前台传送的数据
     */
    @TableField(exist = false)
    private String [] yhztdms;

    /**
     * 行政区划代码
     */
    private String xzqhdm;

    /**
     * 企业类型代码
     */
    private String qylxdm;

    /**
     * 业户类别代码
     */
    private String yhlbdm;

    /**
     * 经济性质代码
     */
    private String jjxzdm;

    /**
     * 资质等级代码
     */
    private String zzdjdm;

    /**
     * 年审状态代码
     */
    private String nsztdm;
    /**
     * 年审状态代码  用于接收前台传送的数据
     */
    @TableField(exist = false)
    private String [] nsztdms;

    /**
     * 营业性质代码
     */
    private String yyxzdm;

    /**
     * 业户名称
     */
    private String yhmc;

    /**
     * 业户简称
     */
    private String yhjc;

    /**
     * 经营许可证号
     */
    private String jyxkzh;

    /**
     * 经营范围代码，多个逗号分隔
     */
    private String jyfw;

    /**
     * 首次发证日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date scfzrq;

    /**
     * 业户地址
     */
    private String yhdz;

    /**
     * 工商执照号
     */
    private String gszzh;

    /**
     * 组织机构代码
     */
    private String zzjgdm;

    /**
     * 统一社会信用代码
     */
    private String tyshxydm;

    /**
     * 税务登记编号
     */
    private String swdjbh;

    /**
     * 开业日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date kyrq;

    /**
     * 母公司统一社会信用代码
     */
    private String mgztyshxydm;

    /**
     * 母公司名称
     */
    private String mgsmc;

    /**
     * 法人身份证号
     */
    private String frsfzh;

    /**
     * 法人代表
     */
    private String frdb;

    /**
     * 法人联系电话
     */
    private String frlxdh;

    /**
     * 发证日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date fzrq;

    /**
     * 有效期止
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date yxqz;

    /**
     * 发证机构
     */
    private String fzjg;

    /**
     * 发证机构统一社会信用代码
     */
    private String fzjgtyshxydm;

    /**
     * 年审年度
     */
    private String nsnd;

    /**
     * 年审日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date nsrq;

    /**
     * 资质等级评定
     */
    private String zzdjpd;

    /**
     * 信誉等级评定
     */
    private String xydjpd;

    /**
     * fzrqStr
     * @return
     */
    @TableField(exist = false)
    private String fzrqStr;

    /**
     * yxqzStr
     * @return
     */
    @TableField(exist = false)
    private String yxqzStr;

    /**
     * 行政区划名称
     * @returnyhXxVO
     */
    @TableField(exist = false)
    private String xzqhmc;

    //检查任务ID
    @TableField(exist = false)
    private String jcrwid;

    @TableField(exist = false)
    private String flager;

    //执法人员姓名
    @TableField(exist = false)
    private String jcry;

    @TableField(exist = false)
    private String jcryxxId;

    @TableField(exist = false)
    private String zfryxxId;

    @TableField(exist = false)
    private String xm;

    @TableField(exist = false)
    private String completeTyshxydm;

    @Override
    public String getId() {
        return yhxxid;
    }

    @Override
    public void setId(String id) {
        this.yhxxid = id;
    }


}
